<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://themeforest.net/user/webbu
 * @since             1.0.0
 * @package           Pointfindercoreelements
 *
 * @wordpress-plugin
 * Plugin Name:       PointFinder Core Elements
 * Plugin URI:        https://themeforest.net/user/webbu/portfolio
 * Description:       PointFinder theme core elements plugin.
 * Version:           1.1.7
 * Author:            Webbu
 * Author URI:        https://themeforest.net/user/webbu
 * License:           Themeforest Split License
 * License URI:       https://themeforest.net/licenses/terms/regular
 * Text Domain:       pointfindercoreelements
 * Domain Path:       /languages
 */


if ( ! defined( 'WPINC' ) ) {
	die;
}

$theme = wp_get_theme();
if ($theme->get( 'TextDomain' ) != 'pointfinder') {
	add_action( 'admin_notices', 'pointfindertheme_notice');
}

if (!class_exists("Redux")) {
	add_action( 'admin_notices', 'pointfindertheme_notice2');
}

function pointfindertheme_notice() {
	echo sprintf( '<div class="updated"><p><strong>PointFinder Core Plugin</strong> %s <strong>PointFinder Theme</strong> %s</p></div>', esc_html__( 'requires', 'templatera' ), esc_html__( 'to be installed and activated on your site.', 'templatera' ) );
}

function pointfindertheme_notice2() {
	echo sprintf( '<div class="updated"><p><strong>PointFinder Core Plugin</strong> %s <strong>Redux Framework Plugin</strong> %s</p></div>', esc_html__( 'requires', 'templatera' ), esc_html__( 'to be installed and activated on your site. Please activate Redux Framework plugin or deactivate and activate again to solve this issue.', 'templatera' ) );
}
	
define( 'PFCOREPLUGIN_NAME_VERSION', '1.1.7' );
define( 'PFCOREELEMENTSDIR', plugin_dir_path( __FILE__ ) );
define( 'PFCOREELEMENTSURL', plugin_dir_url( __FILE__ ) );
define( 'PFCOREELEMENTSURLADMIN', plugin_dir_url( __FILE__ ).'admin/' );
define( 'PFCOREELEMENTSURLPUBLIC', plugin_dir_url( __FILE__ ).'public/' );
define( 'PFCOREELEMENTSURLINC', plugin_dir_url( __FILE__ ).'includes/' );
define( 'PFCOREELEMENTSURLEXT', plugin_dir_url( __FILE__ ).'admin/options/extensions/' );

function activate_pointfindercoreelements() {
	require_once PFCOREELEMENTSDIR . 'includes/class-pointfindercoreelements-activator.php';
	Pointfindercoreelements_Activator::activate();
}

function deactivate_pointfindercoreelements() {
	require_once PFCOREELEMENTSDIR . 'includes/class-pointfindercoreelements-deactivator.php';
	Pointfindercoreelements_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_pointfindercoreelements' );
register_deactivation_hook( __FILE__, 'deactivate_pointfindercoreelements' );

require PFCOREELEMENTSDIR . 'includes/traits/options.php';
require PFCOREELEMENTSDIR . 'includes/class-pointfindercoreelements.php';
function run_pointfindercoreelements() {

	$plugin = new Pointfindercoreelements();
	$plugin->run();

}
run_pointfindercoreelements();