<?php
/**
 * Copyright (c) 2013, Mollie B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * @license     Berkeley Software Distribution License (BSD-License 2) http://www.opensource.org/licenses/bsd-license.php
 * @author      Mollie B.V. <info@mollie.com>
 * @copyright   Mollie B.V.
 * @link        https://www.mollie.com
 *
 * @method stdClass[]|Mollie_API_Object_List all($offset = 0, $limit = 0, array $filters = array())
 * @method stdClass get($id, array $filters = array())
 */
class Mollie_API_Resource_Undefined extends Mollie_API_Resource_Base
{
	/**
	 * @return stdClass
	 */
	protected function getResourceObject ()
	{
		return new stdClass;
	}

	/**
	 * @var string
	 */
	protected $resource_name;

	/**
	 * @param string $resource_name
	 */
	public function setResourceName ($resource_name)
	{
		$this->resource_name = strtolower($resource_name);
	}

	/**
	 * @var string
	 */
	protected $parent_id;

	/**
	 * @param string $parent_id
	 * @return $this
	 */
	public function withParentId ($parent_id)
	{
		$this->parent_id = $parent_id;

		return $this;
	}

	/**
	 * Set the resource to use a certain parent. Use this method before performing a get() or all() call.
	 *
	 * @param mixed $parent An object with an 'id' property
	 * @return $this
	 */
	public function with ($parent)
	{
		$this->parent_id = $parent->id;

		return $this;
	}

	/**
	 * @return string
	 * @throws Mollie_API_Exception
	 */
	public function getResourceName()
	{
		if (strpos($this->resource_name, "_") !== FALSE)
		{
			list($parent_resource, $child_resource) = explode("_", $this->resource_name, 2);

			if (!strlen($this->parent_id))
			{
				throw new Mollie_API_Exception("Subresource '{$this->resource_name}' used without parent '$parent_resource' ID.");
			}

			return "$parent_resource/{$this->parent_id}/$child_resource";
		}

		return $this->resource_name;
	}
}
