<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
define( 'RB_LAZYLOAD_VERSION', 1.0 );

add_action( 'wp_enqueue_scripts', 'rb_lazyload_register_scripts', 50 );
add_filter( 'post_thumbnail_html', 'rb_add_lazyload_featured', 10, 5 );
add_filter( 'max_srcset_image_width', 'rb_max_srcset_image_width', 10 );

if ( ! function_exists( 'rb_lazyload_register_scripts' ) ) {
	function rb_lazyload_register_scripts() {
		if ( defined( 'RB_LAZYLOAD' ) && ! is_admin() ) {
			wp_register_script( 'rb-lazyload-script', plugin_dir_url( __FILE__ ) . 'lazyload.js', array(
				'jquery',
				'imagesloaded'
			), RB_LAZYLOAD_VERSION, true );
			wp_enqueue_script( 'rb-lazyload-script' );
		}
	}

}

/** rb_max_srcset_image_width */
if ( ! function_exists( 'rb_max_srcset_image_width' ) ) {
	function rb_max_srcset_image_width() {
		return 1200;
	}
}

/**
 * @param        $img_html
 * @param string $placeholder_url
 *
 * @return mixed
 * lazyload image
 */
if ( ! function_exists( 'rb_add_lazyload' ) ) {
	function rb_add_lazyload( $img_html, $placeholder_url = '' ) {

		$img_html = preg_replace( '/<img(.*?)src=/is', '<img$1src="' . esc_html( $placeholder_url ) . '" data-src=', $img_html );
		$img_html = str_replace( 'srcset', 'data-srcset', $img_html );
		$img_html = str_replace( 'sizes', 'data-sizes', $img_html );
		$img_html = preg_replace( '/class=(["\'])(.*?)["\']/is', 'class=$1lazyload rb-lazyload rb-autosize $2$1', $img_html );

		return $img_html;
	}
}


/**
 * @param $img_html
 * featured image lazy load
 */
if ( ! function_exists( 'rb_add_lazyload_featured' ) ) {
	function rb_add_lazyload_featured( $img_html, $post_id, $post_thumbnail_id, $size, $attr ) {

		if ( ! defined( 'RB_LAZYLOAD' ) || strpos( $img_html, 'rb-no-lazy' ) !== false || get_query_var( 'amp' ) ) {
			return $img_html;
		}

		$placeholder_url = plugin_dir_url( __FILE__ ) . 'placeholder.svg';
		$holder_size     = apply_filters( 'rb_lazy_holder', 'thumbnail' );

		if ( is_string( $size ) ) {
			$holder_size = $size;
		} else if ( ! empty( $attr ) && is_string( $attr ) ) {
			$holder_size = $attr;
		}

		$holder_size = str_replace( '-2x', '', $holder_size );
		$holder_size = str_replace( '-3x', '', $holder_size );
		$holder_size = str_replace( '-x5', '', $holder_size );
		$holder_size = str_replace( '-small', '', $holder_size );

		if ( has_image_size( $holder_size . '-holder' ) ) {
			$holder_size     = $holder_size . '-holder';
			$placeholder_url = get_the_post_thumbnail_url( $post_id, $holder_size );
		}

		return rb_add_lazyload( $img_html, $placeholder_url );
	}
}


