/** RUBY LAZYLOAD IMAGES */
var RB_LAZY_LOAD = (function (Module, $) {
    "use strict";

    Module.init = function () {
        var self = this;
        var $window = $(window);

        $window.on('load RB:LazyLoad', function () {
            var imgArray = $('.rb-lazyload');
            self.loadImages(imgArray);
            self.reloadSizes(imgArray);
            setTimeout(function(){
                $window.trigger('RB:LazyLoaded');
            }, 10);
        });
    };

    Module.loadImages = function (imgArray) {
        var self = this;
        imgArray.each(function () {
            var imgHTML = $(this);
            if (!imgHTML.hasClass('lazy-loaded')) {
                self.parseImage(imgHTML);
            }
        });
    };

    Module.parseImage = function (imgHTML) {
        if (imgHTML.hasClass('rb-autosize')) {
            imgHTML.attr('sizes', this.getWidth(imgHTML));
        } else {
            imgHTML.attr('sizes', imgHTML.data('sizes'));
        }

        imgHTML.removeClass('lazyload').addClass('lazy-loading');
        imgHTML.attr('srcset', imgHTML.data('srcset'));
        setTimeout(function () {
            imgHTML.attr('src', imgHTML.data('src')).removeClass('lazy-loading').addClass('lazy-loaded');
            imgHTML.removeAttr('style');
        }, 10);
    };

    Module.getWidth = function (imgHTML) {
        var width = imgHTML.parent().width();
        if (!width) {
            width = imgHTML.data('sizes');
        } else {
            width += 'px';
        }
        return width;
    };

    Module.reloadSizes = function (imgArray) {
        var self = this;
        $(window).resize(function () {
            imgArray.each(function () {
                var imgHTML = $(this);
                imgHTML.attr('sizes', self.getWidth(imgHTML));
            });
        })
    };

    return Module;

}(RB_LAZY_LOAD || {}, jQuery));


jQuery(document).ready(function () {
    RB_LAZY_LOAD.init();
});