<?php
/**
 * @param array $settings
 * loop overlay 8
 */
if ( ! function_exists( 'pixwell_post_overlay_8' ) ) :
	function pixwell_post_overlay_8( $settings = array() ) {
		$settings['cat_classes'] = 'is-relative';
		$settings                = pixwell_get_meta_setting( $settings, 'overlay_8' );
		if ( empty( $settings['h_tag'] ) ) {
			$settings['h_tag'] = 'h2';
		}
		
		$post_classes   = array();
		$post_classes[] = 'p-wrap p-overlay p-overlay-8';
		if ( empty( pixwell_post_meta_info( $settings ) ) && empty( $settings['readmore'] ) ) {
			$post_classes[] = 'rb-hf';
		}
		if ( empty( pixwell_get_option( 'meta_author_icon' ) ) || ! isset( $settings['entry_meta']['enabled']['author'] ) ) {
			$post_classes[] = 'no-avatar';
		} ?>
		<article class="<?php echo join( ' ', get_post_class( $post_classes ) ); ?>">
			<div class="p-feat">
				<?php pixwell_post_thumb( 'pixwell_400x600'); ?>
				<div class="content-overlay is-light-text">
					<div class="overlay-holder">
						<?php pixwell_post_cat_info( $settings ); ?>
						<div class="p-header"><?php pixwell_post_title( $settings['h_tag'], $settings['bookmark'] ); ?></div>
						<div class="p-footer">
							<?php echo pixwell_post_meta_info( $settings );
							if ( isset( $settings['entry_meta']['enabled'] ) && empty( $settings['remove_markup'] ) ) {
								pixwell_post_meta_hidden( $settings['entry_meta']['enabled'] );
							} ?>
						</div>
					</div>
				</div>
			</div>
		</article>
	<?php
	}
endif;