<?php
/**
 * @param array $settings
 * loop overlay 2
 */
if ( ! function_exists( 'pixwell_post_overlay_2' ) ) :
	function pixwell_post_overlay_2( $settings = array() ) {
		$settings['cat_classes'] = 'is-relative';
		$settings                = pixwell_get_meta_setting( $settings, 'overlay_2' );
		if ( empty( $settings['h_tag'] ) ) {
			$settings['h_tag'] = 'h3';
		}

		$post_classes   = array();
		$size           = 'pixwell_370x250';
		$post_classes[] = 'p-wrap p-overlay p-overlay-2';
		if ( empty( pixwell_post_meta_info( $settings ) ) ) {
			$post_classes[] = 'rb-hf';
		}
		if ( empty( pixwell_get_option( 'meta_author_icon' ) ) || ! isset( $settings['entry_meta']['enabled']['author'] ) ) {
			$post_classes[] = 'no-avatar';
		}
		if ( ! empty( $settings['feat_size'] ) ) {
			$size = $settings['feat_size'];
		} ?>
		<article class="<?php echo join( ' ', get_post_class( $post_classes ) ); ?>">
			<div class="p-feat">
				<?php pixwell_post_thumb( $size ); ?>
				<div class="content-overlay is-light-text">
					<div class="overlay-holder">
						<?php pixwell_post_cat_info( $settings ); ?>
						<div class="p-header"><?php pixwell_post_title( $settings['h_tag'], $settings['bookmark'] ); ?></div>
						<div class="p-footer">
							<?php echo pixwell_post_meta_info( $settings );
							if ( isset( $settings['entry_meta']['enabled'] ) && empty( $settings['remove_markup'] ) ) {
								pixwell_post_meta_hidden( $settings['entry_meta']['enabled'] );
							} ?>
						</div>
					</div>
				</div>
			</div>
		</article>
	<?php
	}
endif;