<?php
/**
 * @param array $settings
 * @param null  $query_data
 * loop list 5
 */
if ( ! function_exists( 'pixwell_post_list_5' ) ) :
	function pixwell_post_list_5( $settings = array() ) {
		if ( empty( $settings['h_tag'] ) ) {
			$settings['h_tag'] = 'h3';
		}

		$post_classes   = array();
		$post_classes[] = 'p-wrap p-list p-list-5';
		if ( empty( $settings['entry_meta']['enabled'] ) ) {
			$post_classes[] = 'rb-hf';
		}
		if ( empty( pixwell_get_option( 'meta_author_icon' ) ) || ! isset( $settings['entry_meta']['enabled']['author'] ) ) {
			$post_classes[] = ' no-avatar';
		} ?>
		<article class="<?php echo join( ' ', get_post_class( $post_classes ) ); ?>">
			<div class="p-header">
				<?php pixwell_post_cat_dot(); ?>
				<?php pixwell_post_title( $settings['h_tag'], false, 'h6' ); ?>
			</div>
			<div class="p-footer">
				<?php echo pixwell_post_meta_info( $settings );
				if ( isset( $settings['entry_meta']['enabled'] ) && empty( $settings['remove_markup'] ) ) {
					pixwell_post_meta_hidden( $settings['entry_meta']['enabled'] );
				} ?>
			</div>
		</article>
	<?php
	}
endif;
