<?php
/**
 * @param array $settings
 * @param null  $query_data
 * loop list 1
 */
if ( ! function_exists( 'pixwell_post_list_1' ) ) :
	function pixwell_post_list_1( $settings = array() ) {

		$settings = pixwell_get_meta_setting( $settings, 'list_1' );
		$border   = pixwell_get_option( 'border_list_1' );

		if ( empty( $settings['h_tag'] ) ) {
			$settings['h_tag'] = 'h2';
		}
		$settings['cat_classes'] = 'is-absolute';

		$post_classes   = array();
		$post_classes[] = 'p-wrap p-list p-list-1 rb-row';
		if ( ! pixwell_is_featured_image( 'pixwell_370x250-2x' ) ) {
			$post_classes[] = 'no-feat';
		}
		if ( ! empty( $border ) ) {
			$post_classes[] = 'is-border';
		}
		if ( empty( pixwell_post_meta_info( $settings ) ) && empty( $settings['readmore'] ) ) {
			$post_classes[] = 'rb-hf';
		}
		if ( empty( pixwell_get_option( 'meta_author_icon' ) ) || ! isset( $settings['entry_meta']['enabled']['author'] ) ) {
			$post_classes[] = 'no-avatar';
		} ?>
		<article class="<?php echo join( ' ', get_post_class( $post_classes ) ); ?>">
			<?php if ( pixwell_is_featured_image( 'pixwell_370x250-2x' ) ) : ?>
				<div class="rb-col-m12 rb-col-t6 col-left">
					<div class="p-feat-holder">
						<div class="p-feat">
							<?php
							pixwell_post_thumb( 'pixwell_370x250-2x' );
							pixwell_post_cat_info( $settings );
							?>
						</div>
						<?php pixwell_post_review_info( $settings ); ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="rb-col-m12 rb-col-t6 col-right">
				<div class="p-header"><?php pixwell_post_title( $settings['h_tag'], $settings['bookmark'] ); ?></div>
				<?php pixwell_post_summary( $settings ); ?>
				<div class="p-footer">
					<?php echo pixwell_post_meta_info( $settings );
					pixwell_post_readmore( $settings );
					if ( isset( $settings['entry_meta']['enabled'] ) && empty( $settings['remove_markup'] ) ) {
						pixwell_post_meta_hidden( $settings['entry_meta']['enabled'] );
					} ?>
				</div>
			</div>
		</article>
	<?php
	}
endif;
