<?php
/**
 * @param array $settings
 * @param null  $query_data
 * loop grid 6
 */
if ( ! function_exists( 'pixwell_post_grid_6' ) ) :
	function pixwell_post_grid_6( $settings = array() ) {
		$settings = pixwell_get_meta_setting( $settings, 'grid_6' );

		$settings['cat_classes'] = 'is-relative';
		if ( empty( $settings['h_tag'] ) ) {
			$settings['h_tag'] = 'h3';
		}

		$post_classes   = array();
		$post_classes[] = 'p-wrap p-grid p-grid-6';

		$text_style = pixwell_get_option( 'text_style_grid_6' );

		if ( ! empty( $settings['classes'] ) ) {
			$post_classes[] = esc_attr( $settings['classes'] );
		}
		if ( ! empty( $text_style ) && 'light' == $text_style ) {
			$post_classes[] = 'is-light-text';
		}
		if ( ! pixwell_is_featured_image( 'pixwell_400x450' ) ) {
			$post_classes[] = 'no-feat';
		}
		if ( empty( pixwell_post_meta_info( $settings ) ) && empty( $settings['readmore'] ) ) {
			$post_classes[] = 'rb-hf';
		}
		if ( empty( pixwell_get_option( 'meta_author_icon' ) ) || ! isset( $settings['entry_meta']['enabled']['author'] ) ) {
			$post_classes[] = 'no-avatar';
		} ?>
		<article class="<?php echo join( ' ', get_post_class( $post_classes ) ); ?>">
			<?php if ( pixwell_is_featured_image( 'pixwell_400x450' ) ) : ?>
				<div class="p-feat">
					<?php
					pixwell_post_thumb( 'pixwell_400x450' );
					pixwell_post_review_info( $settings );
					?>
				</div>
			<?php endif; ?>
			<div class="p-content-wrap">
				<div class="p-content-inner">
					<?php pixwell_post_cat_info( $settings ); ?>
					<div class="p-header"><?php pixwell_post_title( $settings['h_tag'], $settings['bookmark'] ); ?></div>
					<?php pixwell_post_summary( $settings ); ?>
					<div class="p-footer">
						<?php echo pixwell_post_meta_info( $settings );
						pixwell_post_readmore( $settings );
						if ( isset( $settings['entry_meta']['enabled'] ) && empty( $settings['remove_markup'] ) ) {
							pixwell_post_meta_hidden( $settings['entry_meta']['enabled'] );
						} ?>
					</div>
				</div>
			</div>
		</article>
	<?php
	}
endif;
