<?php
/**
 * @param array $settings
 * @param null  $query_data
 * loop grid 4
 */
if ( ! function_exists( 'pixwell_post_grid_4' ) ) :
	function pixwell_post_grid_4( $settings = array() ) {
		$settings = pixwell_get_meta_setting( $settings, 'grid_4' );
		if ( empty( $settings['h_tag'] ) ) {
			$settings['h_tag'] = 'h4';
		}

		$title_classes  = 'h5';

		$post_classes   = array();
		$post_classes[] = 'p-wrap p-grid p-grid-4';

		if ( ! pixwell_is_featured_image( 'pixwell_280x210' ) ) {
			$post_classes[] = 'no-feat';
		}
		if ( ! empty( $settings['popular_style'] ) ) {
			$post_classes[] = 'is-pop-style';
			$title_classes  = 'h6';
		}
		if ( empty( pixwell_post_meta_info( $settings ) ) ) {
			$post_classes[] = 'rb-hf';
		}
		if ( empty( pixwell_get_option( 'meta_author_icon' ) ) || ! isset( $settings['entry_meta']['enabled']['author'] ) ) {
			$post_classes[] = 'no-avatar';
		} ?>
		<article class="<?php echo join( ' ', get_post_class( $post_classes ) ); ?>">
			<?php if ( pixwell_is_featured_image( 'pixwell_280x210' ) ) : ?>
				<div class="p-feat-holder">
					<div class="p-feat">
						<?php
						pixwell_post_thumb( 'pixwell_280x210' );
						pixwell_post_cat_info( $settings );
						?>
					</div>
					<?php pixwell_post_review_info( $settings ); ?>
				</div>
			<?php endif; ?>
			<div class="p-body">
				<div class="p-header">
					<?php if ( ! empty( $settings['popular_count'] ) ) : ?>
						<span class="counter-index"><?php echo esc_attr( $settings['popular_count'] ); ?>
							<span class="dot-index">.</span></span>
					<?php endif;
					pixwell_post_title( $settings['h_tag'], $settings['bookmark'], $title_classes ); ?>
				</div>
				<div class="p-footer">
					<?php echo pixwell_post_meta_info( $settings );
					if ( isset( $settings['entry_meta']['enabled'] ) && empty( $settings['remove_markup'] ) ) {
						pixwell_post_meta_hidden( $settings['entry_meta']['enabled'] );
					} ?>
				</div>
			</div>
		</article>
	<?php
	}
endif;
