<?php
$pixwell_maxwidth        = absint( $this->get( 'content_max_width' ) );
$pixwell_amp_logo        = pixwell_get_option( 'amp_logo' );
$pixwell_amp_footer_logo = pixwell_get_option( 'amp_footer_logo' );
$pixwell_footer_color    = pixwell_get_option( 'amp_footer_color' );
$pixwell_footer_bg       = pixwell_get_option( 'amp_footer_bg' );

if ( empty( $pixwell_footer_bg ) ) {
	$pixwell_footer_bg = '#333';
}

if ( empty( $pixwell_footer_color ) ) {
	$pixwell_footer_color = '#fff';
} ?>
.amp-wp-content,
.amp-wp-title-bar div {
<?php if ( $pixwell_maxwidth > 0 ) : ?>
	margin: 0 auto;
	max-width: <?php echo sprintf( '%dpx', $pixwell_maxwidth ); ?>;
<?php endif; ?>
}

.amp-wp-header {
text-algin: center;
-webkit-box-shadow: 0 10px 16px 0 rgba(28, 28, 28, 0.04);
-moz-box-shadow: 0 10px 16px 0 rgba(28, 28, 28, 0.04);
box-shadow: 0 10px 16px 0 rgba(28, 28, 28, 0.04);
}

.amp-wp-header div {
text-align: center;
font-size: 1em;
font-weight: 400;
margin: 0 auto;
max-width: calc(840px - 32px);
padding: .875em 16px;
position: relative;
}


.amp-wp-article-content amp-carousel amp-img,
.amp-wp-article-content figure amp-img{
margin: 0 auto;
}

<?php if ( $pixwell_amp_logo['url'] ): ?>
	.amp-wp-header a {
	display: block;
	background-size: contain;
	background-position: center center;
	background-image: url( '<?php echo esc_url( $pixwell_amp_logo['url'] ); ?>' );
	background-repeat: no-repeat;
	height: 40px;
	width: 300px;
	margin: 0 auto;
	text-indent: -9999px;
	}
<?php else: ?>
	.amp-wp-header a {
	display: inline-block;
	text-decoration: none;
	text-transform: uppercase;
	margin: auto;
	letter-spacing: -0.025em;
	font-weight: 900;
	font-size: 38px;
	line-height: 1;
	font-family: 'Quicksand', sans-serif;
	}
<?php endif; ?>


/* Site Icon */
.amp-wp-header .amp-wp-site-icon {
border-radius: 50%;
position: absolute;
right: 18px;
top: 10px;
}

.amp-wp-article-header .amp-wp-meta:last-of-type {
text-align: right;
}

.amp-wp-byline amp-img,
.amp-wp-byline .amp-wp-author {
display: inline-block;
vertical-align: middle;
}

.amp-wp-byline amp-img {
border-radius: 50%;
position: relative;
margin-right: 6px;
}

.amp-wp-posted-on {
text-align: right;
}

/* Featured image */

.amp-wp-article-featured-image amp-img {
margin: 0 auto;
}

.amp-wp-article-featured-image.wp-caption .wp-caption-text {
margin: 0 18px;
}

amp-carousel {
background: rgba(0,0,0,.07);
margin: 0 -16px 1.5em;
}
amp-iframe,
amp-youtube,
amp-instagram,
amp-vine {
background: rgba(0,0,0,.07);
margin: 0 -16px 1.5em;
}

.amp-wp-article-content amp-carousel amp-img {
border: none;
}

amp-carousel > amp-img > img {
object-fit: contain;
}

.amp-wp-iframe-placeholder {
background: #f2f2f2 url( <?php echo esc_url( $this->get( 'placeholder_image_url' ) ); ?> ) no-repeat center 40%;
background-size: 48px 48px;
min-height: 48px;
}

.amp-wp-footer {
background-color: <?php echo sanitize_hex_color( $pixwell_footer_bg ); ?>;
color: <?php echo sanitize_hex_color( $pixwell_footer_color ); ?>;
}

.amp-wp-footer div {
margin: 0 auto;
max-width: calc(840px - 32px);
padding: 40px 20px;
position: relative;
}

.amp-wp-footer h2 {
display: block;
text-align: center;
line-height: 1.375em;
margin: 0 0 .5em;
}

<?php if ( $pixwell_amp_footer_logo['url'] ): ?>
	.amp-wp-footer h2 {
	display: block;
	background-size: contain;
	background-position: center center;
	background-image: url( '<?php echo esc_url( $pixwell_amp_footer_logo['url'] ); ?>' );
	background-repeat: no-repeat;
	height: 60px;
	width: 400px;
	margin: 0 auto;
	margin-bottom: 20px;
	text-indent: -9999px;
	}
<?php endif; ?>



.amp-wp-footer p {
font-size: .875rem;
line-height: 1.5em;
margin: 0 85px 0 0;
}

.amp-wp-footer a {
color: <?php echo sanitize_hex_color( $pixwell_footer_color ); ?>;
text-decoration: none;
opacity: .7;
transition: all .25s ease;
-webkit-transition: all .25s ease;
}

.amp-wp-footer a:hover {
opacity: 1;
}

.back-to-top {
position: fixed;
display: block;
top: auto;
font-size: 20px;
right: 25px;
bottom: 25px;
color: #fff;
height: 40px;
line-height: 36px;
text-align: center;
width: 40px;
vertical-align: middle;
background-color: #333;
transition: all .25s ease;
-webkit-transition: all .25s ease;
}

body .back-to-top {
top: auto;
color: #fff;
}

.back-to-top:hover {
 opacity: 1;
}

.amp-wp-footer p {
text-align: center;
margin: 20px auto 0 auto;
max-width: calc(840px - 32px);
}

.amp-wp-footer li {
display: inline-block;
list-style: none;
font-size: 12px;
padding: 0 10px;
font-weight: 400;
text-transform: uppercase;
}

.amp-wp-footer .menu {
padding: 0;
text-align: center;
}