<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'pixwell_register_options_seo' ) ) {
	function pixwell_register_options_seo() {

		return [
			'id'     => 'pixwell_config_section_seo',
			'title'  => esc_html__( 'SEO Settings', 'pixwell' ),
			'desc'   => esc_html__( 'SThe settings below helps your site optimized for SEO and appear better on the search engines.', 'pixwell' ),
			'icon'   => 'el el-graph',
			'fields' => [
				[
					'id'     => 'section_start_seo_snippets',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'SEO Snippets', 'pixwell' ),
					'notice' => [
						esc_html__( 'Duplicate meta descriptions, Schema markup, and other SEO tags may cause issues. The theme will automatically optimize settings for popular SEO plugins. However, please double-check the settings below to ensure everything is correct.', 'pixwell' ),
						esc_html__( 'We suggest you use the Google Rich Results Test Tool here: search.google.com/test/rich-results', 'pixwell' ),
					],
					'indent' => true,
				],
				[
					'id'          => 'organization_markup',
					'type'        => 'switch',
					'title'       => esc_html__( 'Organization Schema Markup', 'pixwell' ),
					'subtitle'    => esc_html__( 'Enable or disable schema markup for the website to generate brand signals.', 'pixwell' ),
					'description' => esc_html__( 'Disable this option if you prefer to use a third-party plugin.', 'pixwell' ),
					'default'     => true,
				],
				[
					'id'          => 'website_markup',
					'type'        => 'switch',
					'title'       => esc_html__( 'Sitelinks Search Box', 'pixwell' ),
					'subtitle'    => esc_html__( 'Enable or disable website markup.', 'pixwell' ),
					'description' => esc_html__( 'This helps display the Search Box feature for brand SERPs and can make your site name appear in search results.', 'pixwell' ),
					'default'     => true,
				],
				[
					'id'          => 'site_breadcrumb',
					'type'        => 'switch',
					'title'       => esc_html__( 'Breadcrumbs Bar', 'pixwell' ),
					'subtitle'    => esc_html__( 'Breadcrumbs are a hierarchy of links displayed in search engines and on your site.', 'pixwell' ),
					'description' => esc_html__( 'This feature requires the "Breadcrumb NavXT" plugin to work.', 'pixwell' ),
					'default'     => true,
				],
				[
					'id'       => 'site_itemlist',
					'type'     => 'switch',
					'title'    => esc_html__( 'ItemList (Carousel) Markup', 'pixwell' ),
					'subtitle' => esc_html__( 'Enable the Carousels (Item List) schema markup for your Homepage.', 'pixwell' ),
					'default'  => false,
				],
				[
					'id'       => 'website_description',
					'type'     => 'switch',
					'title'    => esc_html__( 'Meta Description', 'pixwell' ),
					'subtitle' => esc_html__( 'Automatically generate meta description tag for your website.', 'pixwell' ),
					'default'  => true,
				],
				[
					'id'     => 'section_end_seo_snippets',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_seo_article',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Schema Article', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'       => 'article_markup',
					'type'     => 'switch',
					'title'    => esc_html__( 'Disable Article Markup', 'pixwell' ),
					'subtitle' => esc_html__( 'Disable the article markup for single posts if you want to use a 3rd party plugin.', 'pixwell' ),
					'default'  => false,
				],
				[
					'id'     => 'section_end_seo_article',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_seo_review',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Schema Review', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'          => 'review_markup',
					'type'        => 'switch',
					'title'       => esc_html__( 'Post Review Markup', 'pixwell' ),
					'subtitle'    => esc_html__( 'Enable or disable review markup for single posts.', 'pixwell' ),
					'description' => esc_html__( 'If you are using a third-party SEO plugin, please check to ensure you do not duplicate schema to avoid SEO issues.', 'pixwell' ),
					'default'     => true,
				],
				[
					'id'     => 'section_end_seo_review',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_seo_information',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Organization Info', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'       => 'site_description',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Home Description', 'pixwell' ),
					'subtitle' => esc_html__( 'Short description will display when searching your main site URL. Leave blank if you use 3rd plugins.', 'pixwell' ),
					'rows'     => 2,
					'default'  => '',
				],
				[
					'id'       => 'site_phone',
					'type'     => 'text',
					'title'    => esc_html__( 'Phone Number', 'pixwell' ),
					'subtitle' => esc_html__( 'input your company phone number.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'       => 'site_email',
					'type'     => 'text',
					'title'    => esc_html__( 'Email', 'pixwell' ),
					'subtitle' => esc_html__( 'input your company main email.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'       => 'site_locality',
					'type'     => 'text',
					'title'    => esc_html__( 'Locality Address', 'pixwell' ),
					'subtitle' => esc_html__( 'input your company city and country address.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'       => 'site_street',
					'type'     => 'text',
					'title'    => esc_html__( 'Street Address', 'pixwell' ),
					'subtitle' => esc_html__( 'input your company street address.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'       => 'postal_code',
					'type'     => 'text',
					'title'    => esc_html__( 'Postal Code', 'pixwell' ),
					'subtitle' => esc_html__( 'input your company local postal code.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'     => 'section_end_seo_information',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_og_tag',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Open Graph', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'          => 'open_graph',
					'type'        => 'switch',
					'title'       => esc_html__( 'Open Graph', 'pixwell' ),
					'subtitle'    => esc_html__( 'Enable or disable Open Graph (social sharing).', 'pixwell' ),
					'description' => esc_html__( 'If you are using a 3rd-party SEO plugin, please check to ensure you do not duplicate Open Graph settings to avoid SEO issues.', 'pixwell' ),
					'default'     => true,
				],
				[
					'id'       => 'facebook_app_id',
					'type'     => 'text',
					'title'    => esc_html__( 'Facebook APP ID', 'pixwell' ),
					'subtitle' => esc_html__( 'input your facebook app ID for OG tags.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'       => 'facebook_default_img',
					'type'     => 'media',
					'url'      => true,
					'preview'  => true,
					'title'    => esc_html__( 'Facebook Default Image', 'pixwell' ),
					'subtitle' => esc_html__( 'This image will be used if the post/page being shared does not contain the featured images', 'pixwell' ),
				],
				[
					'id'     => 'section_end_og_tag',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}