<?php

/**
 * Register the autoloader.
 *
 * Based off the official PSR-0 autoloader example found here:
 * @see https://www.php-fig.org/psr/psr-0/
 *
 * @param string $class The fully-qualified class name
 *
 * @return void
 */

spl_autoload_register(function ($class) {

    $prefix = 'Phox\\';

    $base_dir =  WDES_THEME_DIR . '/includes/';

    $len = strlen($prefix);
    if (0 !== strncmp($prefix, $class, $len)) {
        return;
    }

    $relative_class = substr($class, $len);

    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
        return;
    }

    //Maybe it class file name take WordPress stander
    $split_lite_dir = explode('\\', $relative_class);
    $count_lite_dir = count($split_lite_dir);
    if( $count_lite_dir ){

        $class_name = $split_lite_dir[ $count_lite_dir - 1 ];

        $class_lowercase = strtolower($class_name);
        $replace_underscore = str_replace('_', '-', $class_lowercase);
        $stander_class_name = 'class-'.$replace_underscore;
        $split_lite_dir[ $count_lite_dir - 1 ] = $stander_class_name;

        $file = $base_dir . implode('/', $split_lite_dir) . '.php';

        if (file_exists($file)) {
            require $file;
        }

    }

});



