<?php
namespace Phox\import\demo;

/**
 * Trendy Demo
 * This is Thirty Four demo for the theme
 * the primary color #4549B3
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class Trendy_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'trendy',
            'demo_num'                 => '37',
            'import_file_name'         => 'Trendy Demo',
            'import_zip_url'           => $this->build_demo_url('trendy'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/trendy',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/PxWLNsPF8Ishuv1ByrS0CpwUNzDHVSyDvNwTVXqe.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Trendy Kit',
            'condition_header'         => 68,
            'condition_footer'         => 418,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
