<?php
namespace Phox\import\demo;

/**
 * Temple Demo
 * This is Twenty Four demo for the theme
 * the primary color #197575
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Temple_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'temple',
            'demo_num'                 => '26',
            'import_file_name'         => 'Temple Demo',
            'import_zip_url'           => $this->build_demo_url('temple'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/temple',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/aRsaukzFlUQ1xJQW2IJY7GTWmTvcHEey4jmFJT9f.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'temple kit',
            'condition_header'         => 13,
            'condition_footer'         => 292,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
