<?php
namespace Phox\import\demo;

/**
 * SpacePro Demo
 * This is Twenty Eleven demo for the theme
 * the primary color #1062FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class SpacePro_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'spacepro',
            'demo_num'                 => '30',
            'import_file_name'         => 'SpacePro Demo',
            'import_zip_url'           => $this->build_demo_url('spacepro'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/space-pro',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/4PgNXgrRk5r60JtXgofhYle8heNF3hFFNAfg85eP.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'spacepro Kit',
            'condition_header'         => 116,
            'condition_footer'         => 320,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
