<?php
namespace Phox\import\demo;

/**
 * Shiny Demo
 * This is eighth demo for the theme
 * the primary color #0A2540
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Shiny_Demo extends Demo {


	public function config() {

		return [
			'demo_id'                  => 'shiny',
			'demo_num'                 => '9',
			'import_file_name'         => 'Shiny Demo',
            'import_zip_url'           => $this->build_demo_url('shiny'), // Single ZIP containing all files
			'preview_url'              => 'https://phox.whmcsdes.com/demos/shiny',
			'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/zGCrPgGmviTdNhzbh6XByQx4HOnmwiAhdRiOuUjq.jpg',
			'update_media_url'         => true
		];

	}

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }

	/**
	 * Before Widget Import
	 * check all links in widget and replace it
	 *
	 * @since 1.7.2
	 * @param $import_files
	 * @return mixed
	 */
	public function widgets_import($import_files){

        // check if footer-widget-1 is exist
        if(!isset($import_files->{'footer-widget-1'})){
            return $import_files;
        }

        $site_url = get_site_url();

        $replace_wie_url = str_replace('https://phox.whmcsdes.com/demos/shiny', $site_url, $import_files->{'footer-widget-1'}->{'widget_wdes_about-1'}->{'image'});
        $replace_wie_url = str_replace('wp-content/uploads/sites/9','wp-content/uploads', $replace_wie_url);
        $import_files->{'footer-widget-1'}->{'widget_wdes_about-1'}->{'image'} = $replace_wie_url;

        return $import_files ;

	}

}