<?php
namespace Phox\import\demo;

/**
 * Saas Pro Demo
 * This is Thirty One demo for the theme
 * the primary color #59A9FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class SaasPro_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'saas-pro',
            'demo_num'                 => '33',
            'import_file_name'         => 'Sass Pro Demo',
            'import_zip_url'           => $this->build_demo_url('saaspro'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/ocean',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/Y1lmmX1fjmw6TwWcvCxHnTpPzHetkYjvp9BZer1S.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'SAAS Pro Kit',
            'condition_header'         => 230,
            'condition_footer'         => 532,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
