<?php
namespace Phox\import\demo;

/**
 * RTL Demo
 * This is twelfth demo for the theme
 * the primary color #2f55cf
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class RTL_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'RTL',
            'demo_num'                 => '14',
            'import_file_name'         => 'RTL Demo',
            'import_zip_url'           => $this->build_demo_url('rtl'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/rtl',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/wBNEt9Ngiiv4vSBuQ0hqqZ2Sc9DpPNNHaC2ucFrz.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'rtl-kit',
            'import_notice'            => ! is_rtl() ? esc_html( 'To install this demo you need to change your site language to one of the Right-To-Left languages') : ''
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
