<?php
namespace Phox\import\demo;

/**
 * Ocean Demo
 * This is Thirty demo for the theme
 * the primary color #2A6AFC
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class Ocean_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'ocean',
            'demo_num'                 => '32',
            'import_file_name'         => 'Ocean Demo',
            'import_zip_url'           => $this->build_demo_url('ocean'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/ocean',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/pOwbAY3UMUVMQa6OvkzK9czTxy1aT9NHZiK9m1ha.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Ocean Kit',
            'condition_header'         => 20,
            'condition_footer'         => 354,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
