<?php
namespace Phox\import\demo;

/**
 * Natural Demo
 * This is Thirty Six demo for the theme
 * the primary color #59A9FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class Natural_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'natural',
            'demo_num'                 => '39',
            'import_file_name'         => 'Natural',
            'import_zip_url'           => $this->build_demo_url('natural'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/natural',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/1qxlWFNSFDb1oCzRIOvR7AMFEBVHGtPlr7eljgpT.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Natural Kit',
            'condition_header'         => 71,
            'condition_footer'         => 325,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
