<?php
namespace Phox\import\demo;

/**
 * Moon Demo
 * This is eleventh demo for the theme
 * the primary color #620ABD
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Moon_Demo extends Demo {


	public function config() {

		return [
			'demo_id'                  => 'moon',
			'demo_num'                 => '13',
			'import_file_name'         => 'Moon Demo',
            'import_zip_url'           => $this->build_demo_url('moon'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/moon',
			'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/QRUpaeiXDNWSfGFxTjw5S8t5HCXgj1Cz8zYIAm3N.jpg',
			'update_media_url'         => true,
			'elementor_kit'            => 'moon-kit'
		];

	}

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }


}