<?php
namespace Phox\import\demo;

/**
 * Monster Light Demo
 * This is Thirty Two demo for the theme
 * the primary color #c59af9
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class MonsterLight_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'monster-light',
            'demo_num'                 => '35',
            'import_file_name'         => 'Monster Light Demo',
            'import_zip_url'           => $this->build_demo_url('monsterlight'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/monster-light',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/Iofd1YpPlSkHu6t07f5bIaDXNArkI5ydWbhNsPir.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Monster Light Kit',
            'condition_header'         => 55,
            'condition_footer'         => 334,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
