<?php
namespace Phox\import\demo;

/**
 * Liquid Glass Demo
 * This is Thirty Seven demo for the theme
 * the primary color #59A9FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class LiquidGlass_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'liquid-glass',
            'demo_num'                 => '40',
            'import_file_name'         => 'Liquid Glass',
            'import_zip_url'           => $this->build_demo_url('liquidglass'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/liquid-glass',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/KGimzfu1j4jB1mtO8sZ2CmvGTc6uWBrtAbmFMOm4.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Liquid Glass Kit',
            'condition_header'         => 150,
            'condition_footer'         => 383,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
