<?php
namespace Phox\import\demo;

/**
 * IPhox Demo
 * This is twelfth demo for the theme
 * the primary color #333333
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class IPhox_Demo extends Demo {


	public function config() {

		return [
			'demo_id'                  => 'iphox',
			'demo_num'                 => '16',
			'import_file_name'         => 'IPhox Demo',
            'import_zip_url'           => $this->build_demo_url('iphox'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/iphox',
			'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/sJl1zcE5CONPirvmgiSPWlWkO1shvrDvgkmHwRDS.jpg',
			'update_media_url'         => true,
			'elementor_kit'            => 'iphox'
		];

	}

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }


}