<?php
namespace Phox\import\demo;

/**
 * GoPro Demo
 * This is Twenty Seven demo for the theme
 * the primary color #1062FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class GoPro_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'gopro',
            'demo_num'                 => '29',
            'import_file_name'         => 'GoPro Demo',
            'import_zip_url'           => $this->build_demo_url('gopro'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/gopro',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/xLDzx6SEmIsjC69cg9vYGUn3QJFZqNOHQj4Dea8O.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'gopro Kit',
            'condition_header'         => 11,
            'condition_footer'         => 429,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
