<?php
namespace Phox\import\demo;

/**
 * Galaxy Demo
 * This is nineteenth demo for the theme
 * the primary color #7868E5
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Galaxy_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'galaxy',
            'demo_num'                 => '23',
            'import_file_name'         => 'Galaxy Demo',
            'import_zip_url'           => $this->build_demo_url('galaxy'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/galaxy',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/ch1wTLU2Q6BliQndGOlLxxZUJd8Namigbel6sYx9.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'galaxy kit',
            'condition_header'         => 41,
            'condition_footer'         => 193,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
