<?php
namespace Phox\import\demo;

/**
 * Fancy Pro Demo
 * This is Thirty There demo for the theme
 * the primary color #4CA39B
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class FancyPro_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'fancy-pro',
            'demo_num'                 => '36',
            'import_file_name'         => 'Fancy Pro Demo',
            'import_zip_url'           => $this->build_demo_url('fancypro'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/fancy-pro',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/FLXrvAYSGRhmlkkKGLquc47bBF2bhfssNIVizp01.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Fancy pro Kit',
            'condition_header'         => 85,
            'condition_footer'         => 414,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
