<?php
namespace Phox\import\demo;

/**
 * Extreme Demo
 * This is Twenty Five demo for the theme
 * the primary color #25858e
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Extreme_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'extreme',
            'demo_num'                 => '27',
            'import_file_name'         => 'Extreme Demo',
            'import_zip_url'           => $this->build_demo_url('extreme'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/extreme',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/17rPEGris6qFk3P95eVlF0igr6Vh6pXD9nMNdQoy.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'extreme kit',
            'condition_header'         => 50,
            'condition_footer'         => 882,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
