<?php
namespace Phox\import\demo;

/**
 * Express Demo
 * This is Twenty Two demo for the theme
 * the primary color #0069FF
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Express_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'express',
            'demo_num'                 => '24',
            'import_file_name'         => 'Express Demo',
            'import_zip_url'           => $this->build_demo_url('express'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/express',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/f7UrI78JCLmKveEyTh1DoLuenUmhMaPaIPmBI4Nj.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Express Kit',
            'condition_header'         => 11,
            'condition_footer'         => 171,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
