<?php
namespace Phox\import\demo;

/**
 * Extreme Demo
 * This is Twenty Six demo for the theme
 * the primary color #1062FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Edge_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'edge',
            'demo_num'                 => '28',
            'import_file_name'         => 'Edge Demo',
            'import_zip_url'           => $this->build_demo_url('edge'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/edge',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/QvWzNnpA5nsxIqN9d0MtBZXJToUKIoalyPPpldaG.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'edge kit',
            'condition_header'         => 16,
            'condition_footer'         => 430,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
