<?php
namespace Phox\import\demo;

/**
 * Cloudora_Demo
 * This is Thirty Five demo for the theme
 * the primary color #2375FF
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class Cloudora_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'cloudora',
            'demo_num'                 => '38',
            'import_file_name'         => 'Cloudora',
            'import_zip_url'           => $this->build_demo_url('cloudora'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/cloudora',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/aqrFah5LXC39PA5NDnCGUQzwmizUb75MtzH6YFPw.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Cloudora Kit',
            'condition_header'         => 92,
            'condition_footer'         => 341,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
