<?php
namespace Phox\import\demo;

/**
 * ClassyPro Demo
 * This is nineteenth demo for the theme
 * the primary color #7868E5
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class ClassyPro_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'classy-pro',
            'demo_num'                 => '21',
            'import_file_name'         => 'Classy Pro Demo',
            'import_zip_url'           => $this->build_demo_url('classypro'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/classy-pro',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/HZRHFbET3dQprr7FcKoxNFm4fnqYEnAydu6daKpQ.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'classy-pro-kit',
            'condition_header'         => 13,
            'condition_footer'         => 359,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
