<?php
namespace Phox\import\demo;

/**
 * Cheap Demo
 * This is thirteenth demo for the theme
 * the primary color #2f55cf
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Cheap_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'Cheap',
            'demo_num'                 => '15',
            'import_file_name'         => 'Cheap Demo',
            'import_zip_url'           => $this->build_demo_url('cheap'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/cheap',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/Pbksn3lQOVwFxB6WrjexDJDhBiSRvceo4rm0ofn2.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'cheap-kit'
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
