<?php
!defined('ABSPATH') && exit;

use Phox\core\admin\Dashboard_Menu;
use Phox\core\admin\Enqueue;
use Phox\core\admin\panel\wdes_options\Panel_Controller;

/** @var \Phox\core\License_Activation $is_theme_activated */
if ( is_admin() && wdes_enable_theme_wizard() ){
    $menu_slug = 'phox_options';

    //Add theme option panel to menu
    $dashboard_menu = new Dashboard_Menu(
        parent_slug: 'phox',
        page_title: 'Theme Options',
        menu_slug: $menu_slug,
        menu_title: 'Theme Options',
        capability: 'edit_theme_options'
    );
    $dashboard_menu->register_sub_menu(WDES_OPTIONS_DIR . '/wdes-panel-template.php');

    // Enqueue the admin page CSS and JS
    $panel_enqueue = new Enqueue();
    $panel_enqueue->set_base_url(WDES_ADMIN_ASSETS_URI);

    $panel_enqueue->enqueue_media();
    $panel_enqueue->add_style('admin', 'admin-style', []);
    $panel_enqueue->add_script( 'panel-script-vendor', 'vendor-react' );
    $panel_enqueue->add_script( 'panel-script', 'main' );

    $panel_enqueue->add_google_font(
        'Inter',
        [
            '400',
            '500',
            '600',
            '700'
        ]
    );
    $panel_enqueue->set_hook_suffix('phox_page_phox_options');

    //Fire when admin page load
    $panel_enqueue->enqueue_admin();
}

//Run Panel Controller
Panel_Controller::getInstance();

/* Init data form database */
Panel_Controller::getInstance()->get_db_source()->set_db_options();

/* Get Admin Options */
if( !function_exists('wdes_opts_get') ){
    function wdes_opts_get($opts_name, $default = null) {
        return Panel_Controller::getInstance()->get_db_source()->get_option($opts_name, $default);
    }
}


/* Show Admin Options */
if( !function_exists('wdes_opts_show') ){
    function wdes_opts_show($opts_name, $default = null) {
        $option = wdes_opts_get($opts_name, $default);
        if(!is_array($option)){
            x_wdes()->wdes_get_text($option);
        }
    }
}



