<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\elements\Abstract_Multi_Values;

class Typo extends Abstract_Multi_Values
{

    public function __construct(
        string $id ,
        string $font,
        $size,
        $weight,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->font($font);
        $this->size($size);
        $this->weight($weight);
        $this->properties = [];
    }

    public function default(): void
    {
        $default_values = [
            'id' => 'typo-id',
            'title' => 'Typo',
            'description' => 'Description',
            'type' => $this->type(),
            'default' => [
                'fonts' => '',
                'size'=> '',
                'weight-font'=> ''
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'default' => $this->values,
        ]);
    }

    public function type(): string
    {
        return 'typography';
    }

    private function font(string $font)
    {
        $font = isset( $this->saved_value()['fonts'] ) ? $this->saved_value()['fonts'] : $font;

        $this->values ['fonts']= $font;
    }

    private function size($size)
    {
        $size = isset( $this->saved_value()['size'] ) ? $this->saved_value()['size'] : $size;

        $this->values ['size']= (int) $size;
    }

    private function weight($weight)
    {
        $weight = isset( $this->saved_value()['weight-font'] ) ? $this->saved_value()['weight-font'] : $weight;

        $this->values ['weight-font']= (int) $weight;
    }

    public function validate_values():Element_Validator
    {
        $validator = Element_Validator::getInstance();

        $message = sprintf('The value %s is not a valid', $this->type());

        $validator->validate('string',$this->values['fonts'], $this->id ,$message);
        $validator->validate('int',$this->values['size'], $this->id ,$message);
        $validator->validate('int',$this->values['weight-font'], $this->id ,$message);

        return $validator;

    }

}