<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\Elements_Interface;

class Select extends Abstract_Select_Element
{

    /**
     * @param string $id
     * @param string $value Set value
     * @param string|null $title Set name
     * @param string|null $description Set description
     */
    public function __construct(
        string $id ,
        string $value,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->value($value);
        $this->options = [];
        $this->properties = [];
    }

    public function type(): string
    {
        return 'select';
    }

    public function select_type(): string
    {
        return 'single';
    }
}