<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

class Multi_Select extends Abstract_Select_Element
{
    public function __construct(
        string $id ,
        array $values,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->values($values);
        $this->options = [];
        $this->properties = [];
    }

    public function values(array $values)
    {
        $values = ! empty( $this->saved_value() ) ? $this->saved_value() : $values;
        $this->values = $values;
    }

    public function validate_values():Element_Validator
    {
        $validator = Element_Validator::getInstance();

        $message = sprintf('The value %s is not a valid %s.', 'multi', $this->type());

        $options = [
            'values' => $this->values,
            'choices' => $this->options
        ];

        $validator->validate($this->validate_type(),$options, $this->id ,$message);

        return $validator;

    }

    public function get_prepared_save_values()
    {
        $values = $this->values;

        $validate_values = $this->validate_values();

        if( ! $validate_values->check_status() ) {

            $values = [
                'error' => $validate_values->get_validator()
            ];

        };
        return $values;
    }

    public function validate_type():string
    {
        return 'multiple';
    }

    public function select_type(): string
    {
        return 'multiple';
    }
}