<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

class Color extends Abstract_Basic_Type
{
    /**
     * @param string $id Set ID
     * @param string $value Set value
     * @param string|null $title Set name
     * @param string|null $description Set description
     */
    public function __construct(
        string $id ,
        string $value,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->value($value);
        $this->properties = [];
    }

    public function default(): void
    {
        $default_values = [
            'id' => 'number-id',
            'title' => 'Text',
            'description' => 'Description',
            'type' => $this->type(),
            'colorType' => $this->color_type(),
            'default' => [
                'value' => '',
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'default' => $this->values,
        ]);
    }

    public function type(): string
    {
        return 'color';
    }

    /**
     * Set color type key
     *
     * @since 2.3.6
     * @return string
     */
    public function color_type(): string
    {
        return 'solid';
    }

    public function validate_type(): string
    {
        return 'color';
    }

}