<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

class Color_Gradient extends Abstract_Multi_Values
{

    /**
     * @param string $id Set ID
     * @param string $value Set value
     * @param string|null $title Set name
     * @param string|null $description Set description
     */
    public function __construct(
        string $id ,
        string $value,
        string $value2,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->value($value);
        $this->value2($value2);
        $this->properties = [];
    }

    public function default(): void
    {
        $default_values = [
            'id' => 'number-id',
            'title' => 'Number',
            'description' => 'Description',
            'type' => $this->type(),
            'colorType' => $this->color_type(),
            'default' => [
                'color-one' => '',
                'color-two'=> ''
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'default' => $this->values,
        ]);
    }

    public function type(): string
    {
        return 'color';
    }

    /**
     * Set color type key
     *
     * @since 2.3.6
     * @return string
     */
    public function color_type(): string
    {
        return 'gradient';
    }

    public function value($value): void
    {
        $value = isset( $this->saved_value()['color-one'] ) ? $this->saved_value()['color-one'] : $value;

        $this->values ['color-one']= $value;
    }

    public function value2(string $value2)
    {
        $value2 = isset( $this->saved_value()['color-two'] ) ? $this->saved_value()['color-two'] : $value2;

        $this->values ['color-two']= $value2;
    }

    public function validate_type(): string
    {
        return 'color';
    }

    public function validate_values():Element_Validator
    {
        $validator = Element_Validator::getInstance();

        $message = sprintf('The value %s is not a valid.', $this->type());

        $validator->validate($this->validate_type(),$this->values['color-one'], $this->id ,$message);
        $validator->validate($this->validate_type(),$this->values['color-two'], $this->id ,$message);

        return $validator;

    }

}