<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements\actions;

if ( ! defined( 'ABSPATH' ) ) {
    exit; //Exit if assessed directly
}

use Phox\core\admin\panel\wdes_options\pages\elements\actions\Abstract_Action;

/**
 * Class Remove_Whmcs_Data
 *
 * Removes WHMCS data stored in WordPress options.
 */
class Remove_Whmcs_Data extends Abstract_Action
{

    /**
     * Remove WHMCS data from the WordPress options.
     *
     * This method checks for the presence of WHMCS data in the database option,
     * deletes the option if it exists, and sends a JSON response indicating the
     * success or failure of the operation.
     *
     * @return bool|void Returns false if there is no data to remove, true otherwise.
     */
    private function remove_whmcs_data(){

        $option = get_option( self::WHMCS_FETCH_DATA_OPTION_NAME, '' );

        if( is_null( $option ) ){

            wp_send_json_error( ['type' => 'error remove data', 'message' => $this->button_action_prepare_message('There are no data to remove')]);

            return false;

        }

        delete_option( self::WHMCS_FETCH_DATA_OPTION_NAME );

        wp_send_json_success( ['type' => 'success remove data', 'message' => $this->button_action_prepare_message('Removing data has been completed successfully.')] );

    }

    /**
     * Initiates the removal of WHMCS data by calling the appropriate method.
     *
     * This function serves as an entry point to trigger the WHMCS data removal process.
     *
     * @return void
     */
    public function call():void
    {
        $this->remove_whmcs_data();
    }
}