<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\elements\Element_Validator;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;

class Sections
{
    /**
     * Title
     *
     * @since 2.3.6
     * @access private
     * @var string $title The name of the section
     */
    private string $title;

    /**
     * Description
     *
     * @since 2.3.6
     * @access private
     * @var string $title The description of the section
     */
    private string $description;

    /**
     * Documentation
     *
     * @since 2.3.6
     * @access private
     * @var string $documentation Reference link to an article in the documentation site
     */
    private string $documentation;

    /**
     * Alert
     *
     * @since 2.3.6
     * @access private
     * @var array $alert Content and type is the values that expect on this array
     */
    private array $alert;

    /**
     * @since 2.3.6
     * @access private
     * @var array $elements The components that make up the section
     */
    private array $elements = [];

    /**
     * Array of valid alert types.
     *
     */
    CONST ALERT_TYPES = [
        'info',
        'danger'
    ];

    const DOC_URL = "https://phox.whmcsdes.com/docs/";

    /**
     * @param string $section_name Set section title
     * @param string $description Set section description
     * @param string $doc_link Set link on doc site
     */
    public function __construct(
        string $section_name,
        string $description = '',
        string $doc_link = ''
    )
    {

        $this->title = $section_name;
        $this->description = $description;
        $this->documentation = $this->documentation_link($doc_link);
        $this->alert = [];

    }

    /**
     * Add Element
     *
     * New element on section add on fields of section
     *
     * @param Elements_Interface $element
     * @return static
     */
    public function add_element(Elements_Interface $element): static
    {
        $this->elements['fields'][] = $element->render();
        return $this;
    }

    /**
     * Basic Information
     *
     * Set basic information to the $elements property
     *
     * @since 2.3.6
     * @return void
     */
    private function basic_information (): void
    {
        $this->elements['title'] = $this->title;
        $this->elements['documentation'] = $this->documentation;
        $this->elements['alert'] = $this->alert;
    }

    /**
     * Get Elements
     *
     * @since 2.3.6
     * @return array
     */
    public function get_elements(): array
    {
        $this->basic_information();

        return $this->elements;
    }

    /**
     * Sets the alert content and type.
     *
     * This method sets the alert content.
     * It also sets the alert type if it's one of the valid types defined in ALERT_TYPES.
     * If the provided type is not valid, it defaults to 'none'.
     *
     * @param string $content The content of the alert.
     * @param string $type The type of the alert.
     * @since 2.3.6
     * @return void
     */
    public function set_alert(string $content, string $type): void
    {
        $this->alert ['content'] = $content;
        $this->alert ['type'] = in_array( $type, self::ALERT_TYPES, true ) ? $type : 'none';
    }

    private function documentation_link(string $doc_ref)
    {

        $validation = Element_Validator::getInstance();

        $validation->is_url($doc_ref);

        return $validation->is_url($doc_ref) ? $doc_ref : self::DOC_URL . $doc_ref;
    }

}