<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\elements\Color;
use Phox\core\admin\panel\wdes_options\pages\elements\Color_Gradient;
use Phox\core\admin\panel\wdes_options\pages\elements\Radio;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;
use Phox\core\admin\panel\wdes_options\pages\elements\URL;


class Page_Header extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_section_general();
        $this->create_section_top_bar();
        $this->create_top_header_section();
        $this->create_header_section();
    }

    private function create_section_general():void
    {
        $section_general = new Sections(
            section_name: 'General',
            description: '',
            doc_link: 'creating-website-header'
        );

        $section_general->set_alert(
            content: 'For more flexibility and a more modern, performant setup, we recommend using the Header Builder. To create a custom Header Layout.',
            type: 'info'
        );

        $toggle_sticky_header = new Toggle(
          id: 'sticky-header',
          value: false,
          title: esc_html__('Sticky Header','phox'),
          description: esc_html__('Turn on to enable a sticky header.', 'phox'),
        );

        //End Section
        $this->add_section_collection($section_general,[
            $toggle_sticky_header
        ]);

    }

    private function create_section_top_bar():void
    {
       $section_top_bar = new Sections(
           section_name: 'Top Bar',
           description: '',
           doc_link: 'header-options'
       );

       $section_top_bar->set_alert(
            content: 'The Top Bar works only on the default theme header.',
            type: 'info'
        );

       $toggle_display_top_bar = new Toggle(
           id: 'show-topheader',
           value: false,
           title: esc_html__('Display Top Bar','phox'),
           description: esc_html__('Turn on to enable a top bar.', 'phox')
       );

       $radio_layout = new Radio(
           id: 'top-header-layout',
           value: 'top-header-layout-1',
           title: esc_html__('Layout','phox'),
           description: esc_html__('Choose Layout for top bar.', 'phox'),
       );

        $radio_layout->set_option(
            label: 'Layout 1',
            value: 'top-header-layout-1',
            thumb: 'header-top-bar-layout-1',
        );

        $radio_layout->set_option(
            label: 'Layout 2',
            value: 'top-header-layout-2',
            thumb: 'header-top-bar-layout-2',
        );

       $toggle_display_login = new Toggle(
           id: 'topbar-login',
           value: false,
           title: esc_html__('Display Login Button','phox'),
           description: esc_html__('Turn on to enable a login button.', 'phox')
       );

       $url_login = new URL(
           id: 'topbar-login-url',
           value: '',
           title: esc_html__('Login Button URL','phox'),
           description: esc_html__('Set login button URL.', 'phox')
       );

       $text_login = new Text(
           id: 'topbar-login-text',
           value: esc_html__('Login','phox'),
           title: esc_html__('Login Button Text','phox'),
           description: esc_html__('Set login button Text', 'phox')
       );

       $toggle_display_cart = new Toggle(
           id: 'topbar-cart',
           value: false,
           title: esc_html__('Display Cart Button','phox'),
           description: esc_html__('Turn on to enable a cart button.', 'phox')
       );

       $url_cart = new URL(
           id: 'topbar-cart-url',
           value: '',
           title: esc_html__('Cart Button URL','phox'),
           description: esc_html__('Set cart button URL', 'phox')
       );

       $text_cart = new Text(
           id: 'topbar-cart-text',
           value: esc_html__('Cart','phox'),
           title: esc_html__('Cart Button Text','phox'),
           description: esc_html__('Set cart button Text', 'phox')
       );

       $display_search = new Toggle(
           id: 'topbar-search',
           value: false,
           title: esc_html__('Display Search Button','phox'),
           description: esc_html__('Turn on to enable a search button.', 'phox')
       );

        //End Section
        $this->add_section_collection($section_top_bar,[
            $toggle_display_top_bar,
            $radio_layout,
            $toggle_display_login,
            $url_login,
            $text_login,
            $toggle_display_cart,
            $url_cart,
            $text_cart,
            $display_search
        ]);
    }

    private function create_top_header_section()
    {
        $section_top_header = new Sections(
            section_name: esc_html__('Top Bar Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#topHeader'
        );

        $color_gradient_header_sub_bg = new Color_Gradient(
            id: "color-header-sub-bg",
            value: '#112835',
            value2: '#112835',
            title: esc_html__('Background Colors','phox'),
            description: 'Set left and right background gradient colors.'
        );

        $color_header_top_bar_border_b = new Color(
            id: "color-header-top-bar-border-b",
            value: '#112835',
            title: esc_html__('Bottom Border Color','phox'),
            description: 'Set the bottom border color.'
        );

        $color_header_top_header_link_clr = new Color(
            id: "color-header-top-header-link-clr",
            value: '#ffffff',
            title: esc_html__('Menu | Link Text Color','phox'),
            description: 'Set the color of the menu link text.'
        );

        $color_header_top_header_link_clr_hvr = new Color(
            id: "color-header-top-header-link-clr-hvr",
            value: '#ffffff',
            title: esc_html__('Menu | Hover Link Text Color','phox'),
            description: 'Set the color of the menu link text when hovered.'
        );

        $color_header_top_bar_r_c = new Color(
            id: "color-header-top-bar-r-clr",
            value: '#ffffff',
            title: esc_html__('Social Media | Icon Text Color','phox'),
            description: 'Set the color of the social media icon text.'
        );

        $color_header_top_bar_r_c_hvr = new Color(
            id: "color-header-top-bar-r-clr-hvr",
            value: '#FAE474',
            title: esc_html__('Social Media | Icon Hover Text Color','phox'),
            description: 'Set the color of the social media icon text when hovered.'
        );

        $color_header_top_bar_shortcuts_icon_clr = new Color(
            id: "color-header-top-bar-shortcuts-icon-clr",
            value: '#ffffff',
            title: esc_html__('Shortcuts | Icon Text Color','phox'),
            description: 'Set the color of the shortcuts icon text.'
        );

        $color_header_top_bar_shortcuts_icon_clr_hvr = new Color(
            id: "color-header-top-bar-shortcuts-icon-clr-hvr",
            value: '#ffffff',
            title: esc_html__('Shortcuts | Icon Hover Text Color','phox'),
            description: 'Set the color of the shortcuts icon text when hovered.'
        );

        $color_header_bg_shortcut_border = new Color(
            id: "color-header-bg-shortcut-border",
            value: '#20394a',
            title: esc_html__('Shortcuts | Left Border','phox'),
            description: 'Set the color of the left border of the shortcuts.'
        );

        $color_header_bg_shortcut_title = new Color(
            id: "color-header-bg-shortcut-title",
            value: '#ffffff',
            title: esc_html__('Shortcuts | Title Text Color','phox'),
            description: 'Set the color of the shortcuts title text.'
        );

        $color_header_bg_shortcut_bg_title = new Color(
            id: "color-header-bg-shortcut-bg-title",
            value: '#656d78',
            title: esc_html__('Shortcuts | Title Text Background Color','phox'),
            description: 'Set the background color of the shortcuts title text.'
        );

        $this->add_section_collection($section_top_header, [
            $color_gradient_header_sub_bg,
            $color_header_top_bar_border_b,
            $color_header_top_header_link_clr,
            $color_header_top_header_link_clr_hvr,
            $color_header_top_bar_r_c,
            $color_header_top_bar_r_c_hvr,
            $color_header_top_bar_shortcuts_icon_clr,
            $color_header_top_bar_shortcuts_icon_clr_hvr,
            $color_header_bg_shortcut_border,
            $color_header_bg_shortcut_title,
            $color_header_bg_shortcut_bg_title
        ]);
    }

    private function create_header_section()
    {
        $section_header = new Sections(
            section_name: esc_html__('Header Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#headerColor'
        );

        $color_gradient_header_bg = new Color_Gradient(
            id: "color-header-bg",
            value: '#122d3e',
            value2: '#274961',
            title: esc_html__('Background Colors','phox'),
            description: esc_html__('Set left and right background gradient colors.', 'phox')
        );

        $color_header_bg_border_bottom = new Color(
            id: "color-header-bg-border-bottom",
            value: '#182f3c',
            title: esc_html__('Bottom Border Color','phox'),
            description: 'Set the bottom border color.'
        );

        $color_gradient_header_sticky_background = new Color_Gradient(
            id: "color-header-sticky-background",
            value: '#122d3e',
            value2: '#274961',
            title: esc_html__('Sticky Header | Background Colors','phox'),
            description: esc_html__('Set left and right background gradient colors.', 'phox')
        );

        $color_header_sticky_border_bottom = new Color(
            id: "color-header-sticky-border-bottom",
            value: '#182f3c',
            title: esc_html__('Sticky Header | Bottom Border Color','phox'),
            description: 'Set the bottom border color.'
        );



        $this->add_section_collection($section_header,[
            $color_gradient_header_bg,
            $color_header_bg_border_bottom,
            $color_gradient_header_sticky_background,
            $color_header_sticky_border_bottom
        ]);

    }

}