<?php

namespace Phox\core\admin\panel\wdes_options\pages;


use Phox\core\admin\panel\wdes_options\pages\elements\Media;
use Phox\core\admin\panel\wdes_options\pages\elements\Number;
use Phox\core\admin\panel\wdes_options\pages\elements\Radio;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;


class Page_General extends Abstract_Page {

    /**
     * Build Pages
     *
     * All sections and options that create pages options
     *
     * @since 2.3.6
     * @return void
     */
    public function build_pages(): void
    {
        //Layout Section
        $this->create_section_layout();

        //Logo Section
        $this->create_section_logo();

    }

    /**
     * Section Layout
     *
     * @since 2.3.6
     * @return void
     */
    private function create_section_layout():void
    {
        //Start Section
        $section_layout = new Sections(
            section_name: 'Layout',
            description: '',
            doc_link: 'general-settings-options/#docs-general-layout'
        );

        $layout_mode = new Radio(
            id: 'layout',
            value: 'wide',
            title: 'Layout',
            description: 'Controls the site layout.'
        );

        $layout_mode->set_option(
            label: 'Wide',
            value: 'wide',
            thumb: 'general-layout-wide'
        );

        $layout_mode->set_option(
            label: 'Boxed',
            value: 'boxed',
            thumb: 'general-layout-boxed'
        );

        //Background Patterns
        $background_patterns = new Radio(
            id: 'background_patterns',
            value: 'pattern4',
            title: 'Boxed Layout Background Pattern',
            description: 'Select a Background Pattern.'
        );

        $background_patterns->set_option(
            label: 'Pattern 1',
            value: 'pattern1',
            thumb: 'general-pattern-1'
        );
        $background_patterns->set_option(
            label: 'Pattern 2',
            value: 'pattern2',
            thumb: 'general-pattern-2'
        );
        $background_patterns->set_option(
            label: 'Pattern 3',
            value: 'pattern3',
            thumb: 'general-pattern-3'
        );
        $background_patterns->set_option(
            label: 'Pattern 4',
            value: 'pattern4',
            thumb: 'general-pattern-4'
        );
        $background_patterns->set_option(
            label: 'Pattern 5',
            value: 'pattern5',
            thumb: 'general-pattern-5'
        );
        $background_patterns->set_option(
            label: 'Pattern 6',
            value: 'pattern6',
            thumb: 'general-pattern-6'
        );
        $background_patterns->set_option(
            label: 'Pattern 7',
            value: 'pattern7',
            thumb: 'general-pattern-7'
        );
        $background_patterns->set_option(
            label: 'Pattern 8',
            value: 'pattern8',
            thumb: 'general-pattern-8'
        );
        $background_patterns->set_option(
            label: 'Pattern 9',
            value: 'pattern9',
            thumb: 'general-pattern-9'
        );

        $background_patterns->set_option(
            label: 'Pattern 10',
            value: 'pattern10',
            thumb: 'general-pattern-10'
        );

        //Top Padding
        $top_padding = new Number(
            id: 'top-padding',
            value: 0,
            title: 'Boxed Layout Top Offset',
            description: 'Controls the top offset of the boxed background. Enter values in pixels.'
        );

        $bottom_padding = new Number(
            id: 'bottom-padding',
            value: 0,
            title: 'Boxed Layout Bottom Offset',
            description: 'Controls the bottom offset of the boxed background. Enter values in pixels.'
        );

        //End Section
        $this->add_section_collection($section_layout,[
            $layout_mode,
            $background_patterns,
            $top_padding,
            $bottom_padding
        ]);
    }

    private function create_section_logo()
    {
        $element = [];

        $section_logo = new Sections(
            section_name: 'Logo',
            description: '',
            doc_link:'general-settings-options/#docs-general-logo'
        );

        //Logo
        $upload_logo = new Media(
            id: 'logo',
            value: '',
            title: 'Default Logo',
            description: 'Select an image file for your logo.'
        );

        //Retina
        $retina_logo = new Media(
            id: 'retinal-logo',
            value: '',
            title: 'Retina Default Logo',
            description: 'Select an image file for the retina version of the logo. It should be exactly 2x the size of the main logo.'
        );

        //Sticky Logo
        $sticky_logo = new Media(
            id: 'sticky-header-logo',
            value: '',
            title: 'Sticky Header Logo',
            description:'Select an image file for your sticky header logo.'
        );

        //Favicon
        $favicon = new Media(
            id: 'favicon',
            value: '',
            title: 'Favicon',
            description: 'Favicon for your website at 32px x 32px or 64px x 64px.'
        );

        //Height
        $height_logo = new Number(
            id: 'height-logo',
            value: 20,
            title: 'Logo Height',
            description: 'Add custom height to the logo in pixels.'
        );

        //Text Logo
        $text_logo = new Text(
            id: 'text-logo',
            value: '',
            title: 'Text Logo',
            description: 'Enter the text for the logo. Leave empty to use the logo image.'
        );

        //Logo Size
        $text_logo_size = new Number(
            id: 'text-logo-size',
            value: 20,
            title: 'Text Logo Size',
            description: 'Add custom font size to the text logo in pixels.'
        );
                
        //End Section
        $this->add_section_collection($section_logo, [
            $upload_logo,
            $retina_logo,
            $sticky_logo,
            $favicon,
            $height_logo,
            $text_logo,
            $text_logo_size,
        ]);

    }




}
