<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Color;
use Phox\core\admin\panel\wdes_options\pages\elements\Color_Gradient;
use Phox\core\admin\panel\wdes_options\pages\elements\Media;
use Phox\core\admin\panel\wdes_options\pages\elements\Multi_Select;
use Phox\core\admin\panel\wdes_options\pages\elements\Select;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;
use Phox\core\admin\panel\wdes_options\pages\elements\TextArea;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;

class Page_Footer extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_general_section();
        $this->create_background_section();
        $this->create_payment_section();
        $this->create_footer_section();
        $this->create_footer_widget_section();
        $this->create_footer_widget_about();
        $this->create_footer_widget_calendar();
        $this->create_footer_widget_search();
        $this->create_footer_widget_tag();
        $this->create_footer_widget_newsletter();
        $this->create_footer_widget_payment();
        $this->create_footer_widget_copyright();

    }

    private function create_general_section(): void
    {
        $section_general = new Sections(
            section_name: esc_html__('General', 'phox'),
            description: '',
            doc_link: 'creating-website-footer'
        );

        $section_general->set_alert(
            content: 'For more flexibility and a more modern, performant setup, we recommend using the Footer Builder. To create a custom Footer Layout.',
            type: 'info'
        );

        $toggle_hide_footer = new Toggle(
            id: 'footer-display',
            value: false,
            title: esc_html__('Hide Footer','phox'),
            description: esc_html__('Turn on to hide a footer.','phox'),
        );

        $textarea_copyright = new Textarea(
            id: 'footer-copyright',
            value: '',
            title: esc_html__('Copyright Text','phox'),
            description: esc_html__('Enter the text that is displayed in the copyright bar. Use {{Y}} to set year and {{sitename}} to sit site name', 'phox')
        );

        $this->add_section_collection($section_general,[
            $toggle_hide_footer,
            $textarea_copyright,
        ]);
    }

    private function create_background_section(): void
    {
        $section_background = new Sections(
            section_name: esc_html__('Background Image', 'phox'),
            description: '',
            doc_link: 'footer-options'
        );

        $media_image = new Media(
            id: 'footer-bg-img',
            value: '',
            title: esc_html__('Background Image For Footer Widget Area','phox'),
            description: 'Select an image for the footer widget background. If left empty, the footer background color will be used.'
        );

        $select_image = new Select(
            id: 'footer-bg-img-position',
            value: 'no-repeat;center;;',
            title: esc_html__('Background Position','phox'),
            description: 'Controls how the background image is positioned.'
        );

        $select_image->set_option(
            label: 'Left Top | no-repeat',
            value: 'no-repeat;left top;;'
        );

        $select_image->set_option(
            label: 'Left Top | repeat',
            value: 'repeat;left top;;'
        );

        $select_image->set_option(
            label: 'Left Center | no-repeat',
            value: 'no-repeat;left center;;'
        );

        $select_image->set_option(
            label: 'Left Center | repeat',
            value: 'repeat;left center;;'
        );

        $select_image->set_option(
            label: 'Left Bottom | no-repeat',
            value: 'no-repeat;left bottom;;'
        );

        $select_image->set_option(
            label: 'Left Bottom | repeat',
            value: 'repeat;left bottom;;'
        );

        $select_image->set_option(
            label: 'Center Top | no-repeat',
            value: 'no-repeat;center top;;'
        );

        $select_image->set_option(
            label: 'Center Top | repeat',
            value: 'repeat;center top;;'
        );

        $select_image->set_option(
            label: 'Center Top | repeat-x',
            value: 'repeat-x;center top;;'
        );

        $select_image->set_option(
            label: 'Center Center | no-repeat',
            value: 'no-repeat;center;;'
        );

        $select_image->set_option(
            label: 'Center Center | repeat',
            value: 'repeat;center;;'
        );

        $select_image->set_option(
            label: 'Center Bottom | no-repeat',
            value: 'no-repeat;center bottom;;'
        );

        $select_image->set_option(
            label: 'Center Bottom | repeat',
            value: 'repeat;center bottom;;'
        );

        $select_image->set_option(
            label: 'Center Bottom | repeat-x',
            value: 'repeat-x;center bottom;;'
        );

        $select_image->set_option(
            label: 'Right Top | no-repeat',
            value: 'no-repeat;right top;;'
        );

        $select_image->set_option(
            label: 'Right Top | repeat',
            value: 'repeat;right top;;'
        );

        $select_image->set_option(
            label: 'Right Center | no-repeat',
            value: 'no-repeat;right center;;'
        );

        $select_image->set_option(
            label: 'Right Center | repeat',
            value: 'repeat;right center;;'
        );

        $select_image->set_option(
            label: 'Right Bottom | no-repeat',
            value: 'no-repeat;right bottom;;'
        );

        $select_image->set_option(
            label: 'Right Bottom | repeat',
            value: 'repeat;right bottom;;'
        );

        $select_size = new Select(
            id: 'footer-bg-img-size',
            value: '',
            title: esc_html__('Background Size','phox'),
            description: 'Controls how the background image is sized.'
        );

        $select_size->set_option(
            label: 'Auto',
            value: 'auto'
        );
        $select_size->set_option(
            label: 'Contain',
            value: 'contain'
        );
        $select_size->set_option(
            label: 'Cover',
            value: 'cover'
        );
        $select_size->set_option(
            label: 'Cover, on ultrawide screens only > 1920px',
            value: 'cover-ultrawide'
        );

        $this->add_section_collection($section_background,[
            $media_image,
            $select_image,
            $select_size,
        ]);

    }

    private function create_payment_section()
    {

        $section_payment = new Sections(
            section_name: esc_html__('Payments', 'phox'),
            description: '',
            doc_link: 'footer-options'
        );

        $toggle_enable_payment_method = new Toggle(
            id: 'footer-payments',
            value: false,
            title: esc_html__('Payments Methods','phox'),
            description: esc_html__('Turn on to enable a footer payment methods', 'phox')
        );

        $multiple_select_payment_method = new Multi_Select(
            id: 'choose-payment',
            values: [],
            title: esc_html__('Payments Methods','phox'),
            description: esc_html__('Select the payment methods you want to display in the footer. You can also select multiple methods.', 'phox')
        );

        $multiple_select_payment_method->set_option(
            label: 'Visa',
            value: 'visa',
            thumb:  'visa'
        );

        $multiple_select_payment_method->set_option(
            label: 'Mastercard',
            value: 'mastercard',
            thumb:  'mastercard'
        );

        $multiple_select_payment_method->set_option(
            label: 'Discover',
            value: 'discover',
            thumb:  'discover'
        );

        $multiple_select_payment_method->set_option(
            label: 'Paypal',
            value: 'paypal',
            thumb:  'paypal'
        );

        $multiple_select_payment_method->set_option(
            label: 'Stripe',
            value: 'stripe',
            thumb:  'stripe'
        );

        $multiple_select_payment_method->set_option(
            label: 'Amex',
            value: 'amex',
            thumb:  'amex'
        );

        $multiple_select_payment_method->set_option(
            label: 'JCB',
            value: 'jcb',
            thumb:  'jcb'
        );

        $multiple_select_payment_method->set_option(
            label: 'Diners Club',
            value: 'diners-club',
            thumb:  'diners-club'
        );

        $multiple_select_payment_method->set_option(
            label: 'Apple',
            value: 'apple-pay',
            thumb:  'apple-pay'
        );

        $multiple_select_payment_method->set_option(
            label: 'Amazon',
            value: 'amazon-pay',
            thumb:  'amazon-pay'
        );

        $text_payment_container = new Text(
            id: 'footer-payment-class',
            value: '',
            title: esc_html__('Payment Container class','phox'),
            description: esc_html__('Add a custom class to the payment container.', 'phox')
        );

        $this->add_section_collection($section_payment, [
            $toggle_enable_payment_method,
            $multiple_select_payment_method,
            $text_payment_container
        ]);

    }

    private function create_footer_section():void
    {
        $section_footer = new Sections(
            section_name: esc_html__('Footer Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#footerColor'
        );

        $color_footer_bg = new Color_Gradient(
            id: 'color-footer-bg',
            value: '#122d3e',
            value2: '#274961',
            title: esc_html__('Footer Background Colors', 'phox'),
            description: 'Set left and right background gradient colors.'
        );

        $this->add_section_collection($section_footer,[
            $color_footer_bg
        ]);
    }

    private function create_footer_widget_section():void
    {
        $section_footer_widget = new Sections(
            section_name: esc_html__('Footer | General Widgets Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#generalWidgetsColor'
        );

        $color_footer_heading = new Color(
            id: 'color-footer-heading',
            value: '#ffffff',
            title: esc_html__('Heading Text color', 'phox'),
            description: 'Set the color of the heading text.'
        );

        $color_footer_heading_border = new Color(
            id: 'color-footer-heading-border',
            value: '#d8dde6',
            title: esc_html__('Heading Bottom Border color', 'phox'),
            description: 'Set the color of the heading bottom border.'
        );

        $color_footer_link_clr = new Color(
            id: 'color-footer-link-clr',
            value: '#ffffff',
            title: esc_html__('Link Text Color', 'phox'),
            description: 'Set the color of the link text.'
        );

        $color_footer_link_clr_hvr = new Color(
            id: 'color-footer-link-clr-hvr',
            value: '#FAE474',
            title: esc_html__('Link Text Hover Color', 'phox'),
            description: 'Set the color of the link text when hovered.'
        );

        $color_footer_text_clr = new Color(
            id: 'color-footer-text-clr',
            value: '#ffffff',
            title: esc_html__('Text Color', 'phox'),
            description: 'Set the color of the text.'
        );

        $color_blog_footer_widget_input = new Color(
            id: 'color-blog-footer-widget-input',
            value: '#132a39',
            title: esc_html__('Inputs Background Color', 'phox'),
            description: 'Set the color of the inputs background.'
        );

        $color_blog_footer_widget_input_border = new Color(
            id: 'color-blog-footer-widget-input-border',
            value: '#082333',
            title: esc_html__('Inputs Border Colors', 'phox'),
            description: 'Set the color of the inputs border.'
        );

        $this->add_section_collection($section_footer_widget,[
            $color_footer_heading,
            $color_footer_heading_border,
            $color_footer_link_clr,
            $color_footer_link_clr_hvr,
            $color_footer_text_clr,
            $color_blog_footer_widget_input,
            $color_blog_footer_widget_input_border
        ]);
    }

    private function create_footer_widget_about()
    {
        $section_footer_about = new Sections(
            section_name: esc_html__('Footer | About Us Widget Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#footerAboutUsColor'
        );

        $color_footer_aboutus_widget = new Color(
            id: 'color-footer-aboutus-widget',
            value: '#ffffff',
            title: esc_html__('Text Color', 'phox'),
            description: 'Set the color of the text.'
        );

        $color_footer_aboutus_widget_icons = new Color(
            id: 'color-footer-aboutus-widget-icons',
            value: '#ffffff',
            title: esc_html__('Icons Color', 'phox'),
            description: 'Set the color of the icons.'
        );

        $this->add_section_collection($section_footer_about,[
            $color_footer_aboutus_widget,
            $color_footer_aboutus_widget_icons
        ]);
    }

    private function create_footer_widget_calendar(): void
    {
        $section_footer_calendar = new Sections(
            section_name: esc_html__('Footer | Calendar Widget Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#calendarWidgetColor'
        );

        $color_blog_footer_widget_calendar_head = new Color(
            id: 'color-blog-footer-widget-calendar-head',
            value: '#132a39',
            title: esc_html__('Header Background', 'phox'),
            description: 'Set the color of the header background.'
        );

        $color_blog_footer_widget_calendar_body = new Color(
            id: 'color-blog-footer-widget-calendar-body',
            value: '#132a39',
            title: esc_html__('Body Background', 'phox'),
            description: 'Set the color of the body background.'
        );

        $color_blog_footer_widget_calendar_body_border = new Color(
            id: 'color-blog-footer-widget-calendar-body-border',
            value: '#082333',
            title: esc_html__('Border Color', 'phox'),
            description: 'Set the color of the border.'
        );

        $color_blog_footer_widget_calendar_body_text = new Color(
            id: 'color-blog-footer-widget-calendar-body-text',
            value: '#ffffff',
            title: esc_html__('Text Color', 'phox'),
            description: 'Set the color of the text.'
        );

        $color_blog_footer_widget_calendar_highlighted_bg = new Color(
            id: 'color-blog-footer-widget-calendar-highlighted-bg',
            value: '#C51E3A',
            title: esc_html__('Highlighted Day Background', 'phox'),
            description: 'Set the color of the highlighted day background.'
        );

        $color_blog_footer_widget_calendar_highlighted_text = new Color(
            id: 'color-blog-footer-widget-calendar-highlighted-text',
            value: '#ffffff',
            title: esc_html__('Highlighted Day Text Color', 'phox'),
            description: 'Set the color of the highlighted day text.'
        );

        $this->add_section_collection($section_footer_calendar,[
            $color_blog_footer_widget_calendar_head,
            $color_blog_footer_widget_calendar_body,
            $color_blog_footer_widget_calendar_body_border,
            $color_blog_footer_widget_calendar_body_text,
            $color_blog_footer_widget_calendar_highlighted_bg,
            $color_blog_footer_widget_calendar_highlighted_text
        ]);
    }

    private function create_footer_widget_search()
    {
        $section_footer_widget_search = new Sections(
            section_name: esc_html__('Footer | Search Widget Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#searchWidgetColor'
        );

        $color_blog_footer_widget_search_btn = new Color(
            id: 'color-blog-footer-widget-search-btn',
            value: '#132a39',
            title: esc_html__('Search Input Background','phox'),
            description: 'Set the color of the search input background.'
        );

        $color_blog_footer_widget_search_btn_border = new Color(
            id: 'color-blog-footer-widget-search-btn-border',
            value: '#132a39',
            title: esc_html__('Search Input Border','phox'),
            description: 'Set the color of the search input border.'
        );

        $color_blog_footer_widget_search_bg_btn = new Color(
            id: 'color-footer-search-bg-btn',
            value: '#132a39',
            title: esc_html__('Search Button Background','phox'),
            description: 'Set the color of the search button background.'
        );

        $color_blog_footer_widget_search_clr_btn = new Color(
            id: 'color-footer-search-clr-btn',
            value: '#ffffff',
            title: esc_html__('Search Button Text Color','phox'),
            description: 'Set the color of the search button text.'
        );

        $this->add_section_collection($section_footer_widget_search,[
            $color_blog_footer_widget_search_btn,
            $color_blog_footer_widget_search_btn_border,
            $color_blog_footer_widget_search_bg_btn,
            $color_blog_footer_widget_search_clr_btn
        ]);
    }

    private function create_footer_widget_newsletter()
    {
        $section_footer_widget_newsletter = new Sections(
            section_name: esc_html__('Footer | Newsletter Widget Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#newsletterColor'
        );

        $color_blog_footer_widget_new_letter_inp = new Color(
            id: 'color-footer-new-letter-inp',
            value: '#ffffff',
            title: esc_html__('Text Input Background','phox'),
            description: 'Set the color of the text input background.'
        );

        $color_blog_footer_widget_new_letter_inp_border = new Color(
            id: 'color-footer-new-letter-inp-border',
            value: '#132a39',
            title: esc_html__('Text Input Border','phox'),
            description: 'Set the color of the text input border.'
        );

        $color_blog_footer_widget_new_letter_inp_text = new Color(
            id: 'color-footer-new-letter-text',
            value: '#ffffff',
            title: esc_html__('Text Color','phox'),
            description: 'Set the color of the text.'
        );

        $color_blog_footer_widget_new_letter_sub = new Color_Gradient(
            id: 'color-footer-new-letter-sub',
            value: '#fae474',
            value2: '#c51e3a',
            title: esc_html__('Footer Background', 'phox'),
            description: 'Set left and right background gradient colors.'
        );

        $this->add_section_collection($section_footer_widget_newsletter,[
            $color_blog_footer_widget_new_letter_inp,
            $color_blog_footer_widget_new_letter_inp_border,
            $color_blog_footer_widget_new_letter_inp_text,
            $color_blog_footer_widget_new_letter_sub
        ]);
    }

    private function create_footer_widget_tag()
    {
        $section_footer_widget_tag = new Sections(
            section_name: esc_html__('Footer | Tags Widget Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#tagsColor'
        );

        $color_blog_footer_widget_tags = new Color(
            id: 'color-blog-footer-widget-tags',
            value: '#132a39',
            title: esc_html__('Tag Background','phox'),
            description: 'Set the color of the tag background.'
        );

        $color_blog_footer_widget_tags_text = new Color(
            id: 'color-tags-text',
            value: '#ffffff',
            title: esc_html__('Tag Text Color','phox'),
            description: 'Set the color of the tag text.'
        );

        $color_blog_footer_widget_tags_hvr = new Color(
            id: 'color-blog-footer-widget-tags-hvr',
            value: '#c51e3a',
            title: esc_html__('Tag Background Hover Color','phox'),
            description: 'Set the color of the tag background when hovered.'
        );

        $color_blog_footer_widget_tags_text_hvr = new Color(
            id: 'color-tags-text-hvr',
            value: '#ffffff',
            title: esc_html__('Tag Text Hover Color','phox'),
            description: 'Set the color of the tag text when hovered.'
        );

        $this->add_section_collection($section_footer_widget_tag,[
            $color_blog_footer_widget_tags,
            $color_blog_footer_widget_tags_text,
            $color_blog_footer_widget_tags_hvr,
            $color_blog_footer_widget_tags_text_hvr
        ]);
    }

    private function create_footer_widget_payment(): void
    {
        $section_footer_widget_payment = new Sections(
            section_name: esc_html__('Footer | Payment Methods Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#paymentMethodsColor'
        );

        $color_footer_copyright_border_top = new Color(
            id: 'color-footer-copyright-border-top',
            value: '#0f2836',
            title: esc_html__('Payment Bar Top Border','phox'),
            description: 'Set the color of the payment bar top border.'
        );

        $color_footer_copyright_border_bottom = new Color(
            id: 'color-footer-copyright-border-bottom',
            value: '#0f2836',
            title: esc_html__('Payment Bar Bottom Border','phox'),
            description: 'Set the color of the payment bar bottom border.'
        );

        $color_footer_payment_icon_color = new Color(
            id: 'color-footer-payment-icon-color',
            value: '#ffffff',
            title: esc_html__('Icon Color','phox'),
            description: 'Set the color of the icon.'
        );

        $color_footer_payment_icon_color_hvr = new Color(
            id: 'color-footer-payment-icon-color-hvr',
            value: '#ffffff',
            title: esc_html__('Icon Hover Color','phox'),
            description: 'Set the color of the icon when hovered.'
        );

        $this->add_section_collection($section_footer_widget_payment,[
            $color_footer_copyright_border_top,
            $color_footer_copyright_border_bottom,
            $color_footer_payment_icon_color,
            $color_footer_payment_icon_color_hvr
        ]);
    }

    private function create_footer_widget_copyright(): void
    {
        $section_footer_widget_copyright = new Sections(
            section_name: esc_html__('Footer | Copyrights Bar Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#copyrightBar'
        );

        $color_blog_footer_widget_copyright_top_bar = new Color_Gradient(
            id: 'color-footer-copyright-top-border',
            value: '#112835',
            value2: '#112835',
            title: esc_html__('Background Color', 'phox'),
            description: 'Set the color of the background.'
        );

        $color_blog_footer_widget_copyright_text = new Color(
            id: 'color-footer-copyright-text',
            value: '#ffffff',
            title: esc_html__('Text Color','phox'),
            description: 'Set the color of the text.'
        );

        $color_blog_footer_widget_copyright_link_clr = new Color(
            id: 'color-footer-copyright-link-clr',
            value: '#ffffff',
            title: esc_html__('Link Color','phox'),
            description: 'Set the color of the link.'
        );

        $color_blog_footer_widget_copyright_link_clr_hvr = new Color(
            id: 'color-footer-copyright-link-clr-hvr',
            value: '#ffffff',
            title: esc_html__('Link Hover Color','phox'),
            description: 'Set the color of the link when hovered.'
        );

        $this->add_section_collection($section_footer_widget_copyright,[
            $color_blog_footer_widget_copyright_top_bar,
            $color_blog_footer_widget_copyright_text,
            $color_blog_footer_widget_copyright_link_clr,
            $color_blog_footer_widget_copyright_link_clr_hvr
        ]);
    }

}