<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Color;
use Phox\core\admin\panel\wdes_options\pages\elements\Color_Gradient;

class Page_Color extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {

        $this->create_menu_section();
        $this->create_sub_menu_section();
        $this->create_mega_menu_section();
        $this->create_responsive_menu_section();
        $this->create_heading_menu_section();
        $this->create_shortcode_menu_section();
        $this->create_cf7_section();
        $this->create_whmcs_bridge_section();
        $this->create_woo_section();
    }

    private function create_menu_section()
    {

        $section_menu = new Sections(
            section_name: esc_html__('Menu', 'phox'),
            description: '',
            doc_link: 'color-options/#menuColor'
        );

        $color_header_menu_clr = new Color(
            id: "color-header-menu-clr",
            value: '#ced4d9',
            title: esc_html__('Link Color','phox'),
            description: 'Set the color of the menu link.'
        );

        $color_header_menu_clr_hvr = new Color(
            id: "color-header-menu-clr-hvr",
            value: '#ffffff',
            title: esc_html__('Hover Link Color ','phox'),
            description: 'Set the color of the menu link when hovered.'
        );

        $color_header_menu_clr_hvr_active = new Color(
            id: "color-header-menu-clr-active",
            value: '#ffffff',
            title: esc_html__('Active Link Color ','phox'),
            description: 'Set the color of the active menu link.'
        );

        $this->add_section_collection($section_menu,[
            $color_header_menu_clr,
            $color_header_menu_clr_hvr,
            $color_header_menu_clr_hvr_active
        ]);
    }

    private function create_sub_menu_section()
    {

        $sub_menu = new Sections(
            section_name: esc_html__('Sub Menu', 'phox'),
            description: '',
            doc_link: 'color-options/#subMenuColor'
        );

        $color_header_sub_menu_clr = new Color(
            id: "color-header-sub-menu-clr",
            value: '#7f7f7f',
            title: esc_html__('Link Color','phox'),
            description: 'Set the color of the sub menu link.'
        );

        $color_header_sub_menu_clr_hvr = new Color(
            id: "color-header-sub-menu-clr-hvr",
            value: '#333333',
            title: esc_html__('Hover Link Color ','phox'),
            description: 'Set the color of the sub menu link when hovered.'
        );

        $color_header_sub_menu_clr_border = new Color(
            id: "color-header-sub-menu-clr-border",
            value: '#eeeeee',
            title: esc_html__('Border Color ','phox'),
            description: 'Set the color of the sub menu border.'
        );

        $this->add_section_collection($sub_menu,[
            $color_header_sub_menu_clr,
            $color_header_sub_menu_clr_hvr,
            $color_header_sub_menu_clr_border
        ]);

    }

    private function create_mega_menu_section()
    {
        $mega_menu = new Sections(
            section_name: esc_html__('Mega Menu', 'phox'),
            description: '',
            doc_link: 'color-options/#megaColor'
        );

        $color_header_menu_mega_heading = new Color(
            id: "color-header-menu-mega-heading",
            value: '#423f4f',
            title: esc_html__('Heading Text Color','phox'),
            description: 'Set the color of the heading text.'
        );

        $color_header_menu_mega_heading_hvr = new Color(
            id: "color-header-menu-mega-heading-hvr",
            value: '#f36e46',
            title: esc_html__('Heading Text Hover Color','phox'),
            description: 'Set the color of the heading text when hovered.'
        );

        $color_header_menu_mega_heading_border = new Color(
            id: "color-header-menu-mega-heading-border",
            value: '#eeeeee',
            title: esc_html__('Heading Text Bottom Border Color','phox'),
            description: 'Set the color of the heading text bottom border.'
        );

        $this->add_section_collection($mega_menu,[
            $color_header_menu_mega_heading,
            $color_header_menu_mega_heading_hvr,
            $color_header_menu_mega_heading_border
        ]);
    }

    private function create_responsive_menu_section()
    {
        $responsive_menu = new Sections(
            section_name: esc_html__('Mobile Menu', 'phox'),
            description: '',
            doc_link: 'color-options/#responsiveMenu'
        );

        $color_header_menu_switch_btn = new Color(
            id: "color-header-menu-switch-btn",
            value: '#ffffff',
            title: esc_html__('Toggle Button Color','phox'),
            description: 'Set the color of the toggle button.'
        );

        $color_header_menu_switch_btn_inside = new Color(
            id: "color-header-menu-switch-btn-inside",
            value: '#ffffff',
            title: esc_html__('Close Button Color','phox'),
            description: 'Set the color of the close button.'
        );

        $color_header_dropdown_menu = new Color(
            id: "color-header-dropdown-menu",
            value: '#191919',
            title: esc_html__('Menu Background Color','phox'),
            description: 'Set the background color of the menu.'
        );

        $color_header_overlay_menu_link = new Color(
            id: "color-header-overlay-menu-link",
            value: '#ffffff',
            title: esc_html__('Menu Link Color','phox'),
            description: 'Set the color of the menu link.'
        );

        $color_header_overlay_menu_link_hvr = new Color(
            id: "color-header-overlay-menu-link-hvr",
            value: '#f36e46',
            title: esc_html__('Menu Hover Link Color','phox'),
            description: 'Set the color of the menu link when hovered.'
        );

        $color_header_overlay_menu_link_active = new Color(
            id: "color-header-overlay-menu-link-active",
            value: '#f36e46',
            title: esc_html__('Menu Active Link Color','phox'),
            description: 'Set the color of the active menu link.',
        );

        $color_header_overlay_menu_border = new Color(
            id: "color-header-overlay-menu-border",
            value: '#232323',
            title: esc_html__('Border Color','phox'),
            description: 'Set the color of the border.'
        );

        $color_header_overlay_sub_menu_link = new Color(
            id: "color-header-overlay-sub-menu-link",
            value: '#ffffff',
            title: esc_html__('Sub Menu Link Color','phox'),
            description: 'Set the color of the sub menu link.'
        );

        $color_header_overlay_sub_menu_link_hvr = new Color(
            id: "color-header-overlay-sub-menu-link-hvr",
            value: '#ffffff',
            title: esc_html__('Sub Menu Hover Link Color','phox'),
            description: 'Set the color of the sub menu link when hovered.'
        );

        $this->add_section_collection($responsive_menu,[
            $color_header_menu_switch_btn,
            $color_header_menu_switch_btn_inside,
            $color_header_dropdown_menu,
            $color_header_overlay_menu_link,
            $color_header_overlay_menu_link_hvr,
            $color_header_overlay_menu_link_active,
            $color_header_overlay_menu_border,
            $color_header_overlay_sub_menu_link,
            $color_header_overlay_sub_menu_link_hvr
        ]);
    }

    private function create_heading_menu_section()
    {

        $heading_menu = new Sections(
            section_name: esc_html__('Headings', 'phox'),
            description: '',
            doc_link: 'color-options/#headingsColor'
        );

        $color_heading_h1 = new Color(
            id: 'color-heading-h1',
            value: '#204056',
            title: esc_html__('Heading H1', 'phox'),
            description: 'Set the color of the heading H1.'
        );

        $color_heading_h2 = new Color(
            id: 'color-heading-h2',
            value: '#204056',
            title: esc_html__('Heading H2', 'phox'),
            description: 'Set the color of the heading H2.'
        );

        $color_heading_h3 = new Color(
            id: 'color-heading-h3',
            value: '#204056',
            title: esc_html__('Heading H3', 'phox'),
            description: 'Set the color of the heading H3.'
        );

        $color_heading_h4 = new Color(
            id: 'color-heading-h4',
            value: '#204056',
            title: esc_html__('Heading H4', 'phox'),
            description: 'Set the color of the heading H4.'
        );

        $color_heading_h5 = new Color(
            id: 'color-heading-h5',
            value: '#204056',
            title: esc_html__('Heading H5', 'phox'),
            description: 'Set the color of the heading H5.'
        );

        $color_heading_h6 = new Color(
            id: 'color-heading-h6',
            value: '#204056',
            title: esc_html__('Heading H6', 'phox'),
            description: 'Set the color of the heading H6.'
        );

        $this->add_section_collection($heading_menu,[
            $color_heading_h1,
            $color_heading_h2,
            $color_heading_h3,
            $color_heading_h4,
            $color_heading_h5,
            $color_heading_h6,
        ]);
    }

    private function create_shortcode_menu_section()
    {
        $shortcode_menu = new Sections(
            section_name: esc_html__('Shortcodes', 'phox'),
            description: '',
            doc_link: 'color-options'
        );

        $color_gradient_loading_bg = new Color_Gradient(
            id: 'color-shortcodes-loading-bg',
            value: '#122d3e',
            value2: '#204056',
            title: esc_html__('Loading Screen Background', 'phox'),
            description: esc_html__('Choose Left and Right Background Gradient Colors', 'phox')
        );

        $color_gradient_best_f_bg = new Color_Gradient(
            id: 'color-shortcodes-best-f-bg',
            value: '#C51E3A',
            value2: '#FAE474',
            title: esc_html__('Best Features Section Gradient', 'phox'),
            description: esc_html__('Choose Left and Right Background Gradient Colors', 'phox')
        );

        $color_gradient_info_box = new Color_Gradient(
            id: 'color-shortcodes-info-box',
            value: '#C51E3A',
            value2: '#FAE474',
            title: esc_html__('Info Box Title Color', 'phox'),
            description: ''
        );

        $color_gradient_text_general = new Color_Gradient(
            id: 'color-shortcodes-text-general',
            value: '#C51E3A',
            value2: '#FAE474',
            title: esc_html__('General Elements Text Gradient', 'phox'),
            description: ''
        );

        $color_gradient_bg_general = new Color_Gradient(
            id: 'color-shortcodes-bg-general',
            value: '#C51E3A',
            value2: '#FAE474',
            title: esc_html__('General Elements Background Gradient', 'phox'),
            description: ''
        );

        $color_gradient_faq_bg = new Color_Gradient(
            id: 'color-shortcodes-faq_bg',
            value: '#C51E3A',
            value2: '#FAE474',
            title: esc_html__('FAQ Head Background', 'phox'),
            description: ''
        );

        $color_best_f_bg_r = new Color(
            id: 'color-shortcodes-best-f-bg-r',
            value: '#f8f8f8',
            title: esc_html__('Best Features Section Text Background', 'phox'),
            description: ''
        );

        $this->add_section_collection($shortcode_menu,[
            $color_gradient_loading_bg,
            $color_gradient_best_f_bg,
            $color_best_f_bg_r,
            $color_gradient_info_box,
            $color_gradient_text_general,
            $color_gradient_bg_general,
            $color_gradient_faq_bg
        ]);
    }

    private function create_cf7_section():void
    {
        $section_cr7 = new Sections(
            section_name: esc_html__('Contact Form 7', 'phox'),
            description: '',
            doc_link: 'color-options/#contactForm'
        );

        $color_shortcode_cf7_input_hvr = new Color(
            id: 'color-shortcode-cf7-input-hvr',
            value: '#122d3e',
            title: esc_html__('Inputs Border Hover Color', 'phox'),
            description: 'Set the color of the inputs when hovered.'
        );

        $color_shortcode_cf7_send_btn_bg = new Color(
            id: 'color-shortcode-cf7-send-btn-bg',
            value: '#204056',
            title: esc_html__('Submit Button Background Color', 'phox'),
            description: 'Set the color of the submit button.'
        );

        $color_shortcode_cf7_send_btn_bg_hvr = new Color(
            id: 'color-shortcode-cf7-send-btn-bg-hvr',
            value: '#C51E3A',
            title: esc_html__('Submit Button Background Hover Color', 'phox'),
            description: 'Set the color of the submit button when hovered.'
        );

        $this->add_section_collection($section_cr7,[
            $color_shortcode_cf7_input_hvr,
            $color_shortcode_cf7_send_btn_bg,
            $color_shortcode_cf7_send_btn_bg_hvr
        ]);
    }

    private function create_whmcs_bridge_section():void
    {
        $section_whmcs_bridge = new Sections(
            section_name: esc_html__('WHMCS Bridge', 'phox'),
            description: '',
            doc_link: 'color-options/#bridgeColor'
        );

        $color_bridge_bg = new Color_Gradient(
            id: 'color-bridge-bg',
            value: '#122d3e',
            value2: '#274961',
            title: esc_html__('Header Background Color', 'phox'),
            description: 'Set left and right background gradient colors.'
        );

        $color_bridge_search = new Color(
            id: 'color-bridge-search',
            value: '#cc2241',
            title: esc_html__('Domain Search Button Background', 'phox'),
            description: 'Set the color of the domain search button.'
        );

        $color_bridge_transfer = new Color(
            id: 'color-bridge-transfer',
            value: '#2b516b',
            title: esc_html__('Domain Transfer Button Background', 'phox'),
            description: 'Set the color of the domain transfer button.'
        );

        $color_bridge_home_bg = new Color(
            id: 'color-bridge-home-bg',
            value: '#c51e39',
            title: esc_html__('Home Shortcuts Background', 'phox'),
            description: 'Set the color of the home shortcuts.'
        );

        $color_bridge_home_sc_c = new Color(
            id: 'color-bridge-home-sc-c',
            value: '#b62c46',
            title: esc_html__('Home Shortcuts Border Color', 'phox'),
            description: 'Set the color of the home shortcuts border.'
        );

        $color_bridge_twitter_border = new Color(
            id: 'color-bridge-twitter-border',
            value: '#c51e39',
            title: esc_html__('Tweets Border Color', 'phox'),
            description: 'Set the color of the tweets border.'
        );

        $color_bridge_sidebar_head = new Color(
            id: 'color-bridge-sidebar-head',
            value: '#2c526b',
            title: esc_html__('Sidebar Panel Header Background', 'phox'),
            description: 'Set the color of the sidebar panel header.'
        );

        $color_bridge_sidebar_active_tab = new Color(
            id: 'color-bridge-sidebar-active-tab',
            value: '#C51E39',
            title: esc_html__('Sidebar Panel Body Active Tab Background', 'phox'),
            description: 'Set the color of the sidebar panel body active tab.'
        );

        $color_bridge_btn_bg = new Color(
            id: 'color-bridge-btn-bg',
            value: '#C51E39',
            title: esc_html__('Buttons Background Color', 'phox'),
            description: 'Set the color of the buttons.'
        );

        $this->add_section_collection($section_whmcs_bridge,[
            $color_bridge_bg,
            $color_bridge_search,
            $color_bridge_transfer,
            $color_bridge_home_bg,
            $color_bridge_home_sc_c,
            $color_bridge_twitter_border,
            $color_bridge_sidebar_head,
            $color_bridge_sidebar_active_tab,
            $color_bridge_btn_bg
        ]);
    }

    private function create_woo_section()
    {

        $section_woo_section = new Sections(
            section_name: esc_html__('WooCommerce', 'phox'),
            description: '',
            doc_link: 'color-options/#wooColors'
        );

        $color_woocommerce_btn_count = new Color(
            id: 'color-woocommerce-btn-count',
            value: '#c51e39',
            title: esc_html__('Cart Count Button Background', 'phox'),
            description: 'Set the color of the cart count button.'
        );

        $color_woocommerce_btn_view_cart = new Color(
            id: 'color-woocommerce-btn-view-cart',
            value: '#244960',
            title: esc_html__('View Cart Button Background', 'phox'),
            description: 'Set the color of the view cart button.'
        );

        $color_woocommerce_btn_view_cart_hvr = new Color(
            id: 'color-woocommerce-btn-view-cart-hvr',
            value: '#c51e39',
            title: esc_html__('View Cart Button Hover Background', 'phox'),
            description: 'Set the color of the view cart button when hovered.'
        );

        $color_woocommerce_btn_checkout = new Color(
            id: 'color-woocommerce-btn-checkout',
            value: '#c51e39',
            title: esc_html__('Checkout Button Background', 'phox'),
            description: 'Set the color of the checkout button.'
        );

        $color_woocommerce_btn_checkout_hvr = new Color(
            id: 'color-woocommerce-btn-checkout-hvr',
            value: '#244960',
            title: esc_html__('Checkout Button Hover Background', 'phox'),
            description: 'Set the color of the checkout button when hovered.'
        );

        $color_woocommerce_bread_bg = new Color_Gradient(
            id: 'color-woocommerce-bread_bg',
            value: '#122d3e',
            value2: '#274961',
            title: esc_html__('Breadcrumb Background', 'phox'),
            description: 'Set left and right background gradient colors.'
        );

        $color_woocommerce_product_h_brd = new Color(
            id: 'color-woocommerce-product-h-brd',
            value: '#c51e39',
            title: esc_html__('Product Border Color Hover', 'phox'),
            description: 'Set the color of the product border when hovered.'
        );

        $color_woocommerce_product_btn = new Color(
            id: 'color-woocommerce-product-btn',
            value: '#cc2241',
            title: esc_html__('Product Cart Button Background', 'phox'),
            description: 'Set the color of the product cart button.'
        );

        $color_woocommerce_product_sale = new Color(
            id: 'color-woocommerce-product-sale',
            value: '#c51e39',
            title: esc_html__('Product Sale Button Background', 'phox'),
            description: 'Set the color of the product sale button.'
        );

        $color_woocommerce_product_title = new Color(
            id: 'color-woocommerce-product-title',
            value: '#204056',
            title: esc_html__('Product Title Text Color', 'phox'),
            description: 'Set the color of the product title text.'
        );

        $color_woocommerce_widget_title = new Color(
            id: 'color-woocommerce-widget-title',
            value: '#204056',
            title: esc_html__('Widgets Title Text Color', 'phox'),
            description: 'Set the color of the widgets title text.'
        );

        $color_woocommerce_widget_cart = new Color(
            id: 'color-woocommerce-widget-cart',
            value: '#244960',
            title: esc_html__('Widgets Cart Button Background', 'phox'),
            description: 'Set the color of the widgets cart button.'
        );

        $color_woocommerce_widget_cart_hvr = new Color(
            id: 'color-woocommerce-widget-cart-hvr',
            value: '#cc2241',
            title: esc_html__('Widgets Cart Button Hover Background Color', 'phox'),
            description: 'Set the color of the widgets cart button when hovered.'
        );

        $color_woocommerce_widget_filter = new Color(
            id: 'color-woocommerce-widget-filter',
            value: '#d2274a',
            title: esc_html__('Widgets Filter Range Bar', 'phox'),
            description: 'Set the color of the widgets filter range bar.'
        );

        $color_woocommerce_product_page_title = new Color(
            id: 'color-woocommerce-product-page-title',
            value: '#204056',
            title: esc_html__('Product Page Title Text Color', 'phox'),
            description: 'Set the color of the product page title text.'
        );

        $color_woocommerce_product_page_feature = new Color(
            id: 'color-woocommerce-product-page-feature',
            value: '#c51e39',
            title: esc_html__('Product Page Features Text Color', 'phox'),
            description: 'Set the color of the product page features text.'
        );

        $color_woocommerce_product_page_btn = new Color(
            id: 'color-woocommerce-product-page-btn',
            value: '#c51e39',
            title: esc_html__('Product Page Cart Button Background Color', 'phox'),
            description: 'Set the color of the product page cart button.'
        );

        $color_woocommerce_product_tabs = new Color(
            id: 'color-woocommerce-product-tabs',
            value: '#c51e39',
            title: esc_html__('Product Page Tabs Background', 'phox'),
            description: 'Set the color of the product page tabs.'
        );

        $color_woocommerce_product_order_bg = new Color(
            id: 'color-woocommerce-product-order-bg',
            value: '#244960',
            title: esc_html__('Checkout Order Background', 'phox'),
            description: 'Set the color of the checkout order background.'
        );

        $color_woocommerce_search_bg = new Color(
            id: 'color-woocommerce-search-bg',
            value: '#204056',
            title: esc_html__('Search Widget Button Background', 'phox'),
            description: 'Set the color of the search widget button.'
        );

        $color_woocommerce_profile_link = new Color(
            id: 'color-woocommerce-profile-link',
            value: '#c51e3a',
            title: esc_html__('Profile Links Text Color', 'phox'),
            description: 'Set the color of the profile links.'
        );

        $color_woocommerce_pagination_bg = new Color(
            id: 'color-woocommerce-pagination-bg',
            value: '#f3f5f9',
            title: esc_html__('Pagination Button Background', 'phox'),
            description: ''
        );

        $color_woocommerce_pagination_color = new Color(
            id: 'color-woocommerce-pagination-color',
            value: '#204056',
            title: esc_html__('Pagination Button Text Color', 'phox'),
            description: 'Set the color of the pagination button text.'
        );

        $color_woocommerce_pagination_bg_active = new Color(
            id: 'color-woocommerce-pagination-bg-active',
            value: '#204056',
            title: esc_html__('Pagination Active Button Background', 'phox'),
            description: 'Set the color of the pagination active button.'
        );

        $color_woocommerce_pagination_color_active = new Color(
            id: 'color-woocommerce-pagination-color-active',
            value: '#ffffff',
            title: esc_html__('Pagination Active Button Text Color', 'phox'),
            description: 'Set the color of the pagination active button text.'
        );

        $this->add_section_collection($section_woo_section,[
            $color_woocommerce_btn_count,
            $color_woocommerce_btn_view_cart,
            $color_woocommerce_btn_view_cart_hvr,
            $color_woocommerce_btn_checkout,
            $color_woocommerce_btn_checkout_hvr,
            $color_woocommerce_bread_bg,
            $color_woocommerce_product_h_brd,
            $color_woocommerce_product_btn,
            $color_woocommerce_product_sale,
            $color_woocommerce_product_title,
            $color_woocommerce_widget_title,
            $color_woocommerce_widget_cart,
            $color_woocommerce_widget_cart_hvr,
            $color_woocommerce_widget_filter,
            $color_woocommerce_product_page_title,
            $color_woocommerce_product_page_feature,
            $color_woocommerce_product_page_btn,
            $color_woocommerce_product_tabs,
            $color_woocommerce_product_order_bg,
            $color_woocommerce_search_bg,
            $color_woocommerce_profile_link,
            $color_woocommerce_pagination_bg,
            $color_woocommerce_pagination_color,
            $color_woocommerce_pagination_bg_active,
            $color_woocommerce_pagination_color_active
        ]);
    }



}