<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Color;
use Phox\core\admin\panel\wdes_options\pages\elements\Color_Gradient;
use Phox\core\admin\panel\wdes_options\pages\elements\Number;
use Phox\core\admin\panel\wdes_options\pages\elements\Radio;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;
use Phox\core\admin\panel\wdes_options\pages\elements\TextArea;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;

class Page_Blog extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_breadcrumbs_section();
        $this->create_post_section();
        $this->create_pin_post_section();
        $this->create_blog_section();
    }

    private function create_breadcrumbs_section(): void
    {
        $section_breadcrumbs = new Sections(
            section_name: esc_html__('Breadcrumb', 'phox'),
            description: '',
            doc_link: 'pages-options/#blogOptions'
        );

        $text_title = new Text(
            id:'blog-page-title',
            value:'Blog',
            title: esc_html__('Title','phox'),
            description: 'Enter the title of the blog page. This title will be displayed on the blog page.'
        );

        $textarea_description = new Textarea(
            id:'blog-page-description',
            value: '',
            title: esc_html__('Description','phox'),
            description: 'Enter the description of the blog page. This title will be displayed on the blog page.'
        );

        $this->add_section_collection($section_breadcrumbs,[
            $text_title,
            $textarea_description
        ]);
    }

    private function create_post_section()
    {
        $section_post = new Sections(
            section_name: esc_html__('Post', 'phox'),
            description: '',
            doc_link: 'pages-options/#blogOptions'
        );

        $number_excerpt_len = new Number(
            id:'blog-page-number',
            value:30,
            title: esc_html__('Excerpt Length','phox'),
            description: esc_html__('Controls post excerts length for the assigned blog page in (Settings / Reading) or blog archive pages. Limit is applied to number of letter or words depending on Basis for Excerpt Length option.', 'phox')
        );

        $toggle_hide_feature_image = new Toggle(
            id:'blog-feature-img',
            value:false,
            title: esc_html__('Hide Featured Image','phox'),
            description: 'Turn on to hide a featured image.'
        );

        $toggle_hide_date = new Toggle(
            id:'blog-time',
            value:false,
            title: esc_html__('Hide Date','phox'),
            description: 'Turn on to hide a date.'
        );

        $toggle_hide_category = new Toggle(
            id:'blog-category',
            value:false,
            title: esc_html__('Hide Category','phox'),
            description: 'Turn on to hide a category.'
        );

        $toggle_hide_comments_counter = new Toggle(
            id:'blog-comments-counter',
            value:false,
            title: esc_html__('Hide Comments Counter','phox'),
            description: 'Turn on to hide a comments counter.'
        );

        $toggle_hide_author = new Toggle(
            id:'blog-author',
            value:false,
            title: esc_html__('Hide Author','phox'),
            description: 'Turn on to hide author box.'
        );

        $this->add_section_collection($section_post,[
            $number_excerpt_len,
            $toggle_hide_feature_image,
            $toggle_hide_date,
            $toggle_hide_author,
            $toggle_hide_category,
            $toggle_hide_comments_counter
        ]);
    }

    private function create_pin_post_section(): void
    {
        $section_pin_post = new Sections(
            section_name: esc_html__('Pin Posts', 'phox'),
            description: '',
            doc_link: 'pages-options/#blogOptions'
        );

        $toggle_hide_pin_post = new Toggle(
            id:'blog-pin-post-show',
            value:false,
            title: esc_html__('Hide Pin Posts','phox'),
            description: 'Turn on to hide a pin posts.'
        );

        $radio_layout = new Radio(
            id:'blog-pin-post',
            value:'left',
            title: esc_html__('Pin Posts Layout','phox'),
            description: 'Controls the pin posts layout.'
        );

        $radio_layout->set_option(
            label: 'Left',
            value: 'left',
            thumb: 'blog-layout-pin-post-left'
        );

        $radio_layout->set_option(
            label: 'Right',
            value: 'right',
            thumb: 'blog-layout-pin-post-right'
        );

        $this->add_section_collection($section_pin_post,[
            $toggle_hide_pin_post,
            $radio_layout
        ]);
    }

    private function create_blog_section(): void
    {
        $section_blog = new Sections(
            section_name: esc_html__('Blog Styling', 'phox'),
            description: '',
            doc_link: 'color-options/#blogColor'
        );

        $color_blog_breadcrumb = new Color_Gradient(
            id: 'color-blog-breadcrumb',
            value: '#122d3e',
            value2: '#274961',
            title: esc_html__('Blog Breadcrumb Background Colors', 'phox'),
            description: 'Set left and right background gradient colors.'
        );

        $color_blog_breadcrumb_title = new Color(
            id: 'color-blog-blog-breadcrumb-title',
            value: '#ffffff',
            title: esc_html__('Blog Breadcrumb Title Text Color', 'phox'),
            description: 'Set the color of the blog breadcrumb title text.'
        );

        $color_blog_breadcrumb_description = new Color(
            id: 'color-blog-blog-breadcrumb-description',
            value: '#ffffff',
            title: esc_html__('Blog Breadcrumb Description Text Color', 'phox'),
            description: 'Set the color of the blog breadcrumb description text.'
        );

        $color_blog_breadcrumb_link = new Color(
            id: 'color-blog-blog-breadcrumb-link',
            value: '#ffffff',
            title: esc_html__('Blog Breadcrumb Link Text Color', 'phox'),
            description: 'Set the color of the blog breadcrumb link text.'
        );

        $color_blog_breadcrumb_link_active = new Color(
            id: 'color-blog-blog-breadcrumb-link-active',
            value: '#ffffff',
            title: esc_html__('Blog Breadcrumb Active Link Text Color', 'phox'),
            description: 'Set the color of the blog breadcrumb active link text.'
        );

        $color_blog_breadcrumb_link_separator = new Color(
            id: 'color-blog-blog-breadcrumb-link-separator',
            value: '#ffffff',
            title: esc_html__('Blog Breadcrumb Link Separator Color', 'phox'),
            description: 'Set the color of the blog breadcrumb link separator.'
        );

        $color_blog_post_title = new Color(
            id: 'color-blog-post-title',
            value: '#204056',
            title: esc_html__('Post Title Text Color', 'phox'),
            description: 'Set the color of the post title text.'
        );

        $color_blog_post_title_hover = new Color(
            id: 'color-blog-post-title-hover',
            value: '#204056',
            title: esc_html__('Post Title Text Hover Color', 'phox'),
            description: 'Set the color of the post title text when hovered.'
        );

        $color_blog_post_more_btn = new Color(
            id: 'color-blog-post-more-btn',
            value: '#204056',
            title: esc_html__('Post Read More Button Text Color', 'phox'),
            description: 'Set the color of the post read more button text.'
        );

        $color_blog_post_more_btn_border = new Color(
            id: 'color-blog-post-more-btn-border',
            value: '#204056',
            title: esc_html__('Post Read More Button Border Color', 'phox'),
            description: 'Set the color of the post read more button border.'
        );

        $color_blog_post_more_btn_bg_hvr = new Color(
            id: 'color-blog-post-more-btn-bg-hvr',
            value: '#204056',
            title: esc_html__('Post Read More Button Background Hover Color', 'phox'),
            description: 'Set the color of the post read more button background when hovered.'
        );

        $color_blog_post_more_btn_hvr = new Color(
            id: 'color-blog-post-more-btn-hvr',
            value: '#ffffff',
            title: esc_html__('Post Read More Button Text Hover Color', 'phox'),
            description: 'Set the color of the post read more button text when hovered.'
        );

        $color_blog_post_more_btn_border_hvr = new Color(
            id: 'color-blog-post-more-btn-border-hvr',
            value: '#204056',
            title: esc_html__('Post Read More Button Border Hover Color', 'phox'),
            description: 'Set the color of the post read more button border when hovered.'
        );

        $color_blog_widget_title = new Color(
            id: 'color-blog-widget-title',
            value: '#204056',
            title: esc_html__('Sidebar Widgets Title Text Color', 'phox'),
            description: 'Set the color of the sidebar widgets title text.'
        );

        $color_blog_widget_link = new Color(
            id: 'color-blog-widget-link',
            value: '#C51E3A',
            title: esc_html__('Sidebar Widgets Link Hover Color', 'phox'),
            description: 'Set the color of the sidebar widgets link when hovered.'
        );

        $color_blog_search_widget_send = new Color(
            id: 'color-blog-search-widget-send',
            value: '#204056',
            title: esc_html__('Search Widget Search Button Background', 'phox'),
            description: 'Set the color of the search widget search button background.'
        );

        $color_blog_widget_posts_title_clr = new Color(
            id: 'color-blog-widget-posts-title-clr',
            value: '#204056',
            title: esc_html__('Recent Posts Widget Post Title', 'phox'),
            description: 'Set the color of the recent posts widget post title.'
        );

        $color_blog_widget_posts_title_clr_hvr = new Color(
            id: 'color-blog-widget-posts-title-clr-hvr',
            value: '#C51E3A',
            title: esc_html__('Recent Posts Widget Post Title Hover', 'phox'),
            description: 'Set the color of the recent posts widget post title when hovered.'
        );

        $color_blog_post_heading_main = new Color(
            id: 'color-blog-post-heading-main',
            value: '#204056',
            title: esc_html__('Single Headings Text Color', 'phox'),
            description: 'Set the color of the single headings text.'
        );

        $color_blog_tags_widget_tag = new Color(
            id: 'color-blog-tags-widget-tag',
            value: '#C51E3A',
            title: esc_html__('Single Tags Background Hover Color', 'phox'),
            description: 'Set the color of the single tags background when hovered. '
        );

        $color_blog_related_posts_title = new Color(
            id: 'color-blog-related-posts-title',
            value: '#204056',
            title: esc_html__('Related Posts Title Text Color', 'phox'),
            description: 'Set the color of the related posts title text.'
        );

        $color_blog_related_posts_title_hvr = new Color(
            id: 'color-blog-related-posts-title-hvr',
            value: '#c51e3a',
            title: esc_html__('Related Posts Title Text Hover', 'phox'),
            description: 'Set the color of the related posts title text when hovered.'
        );

        $color_blog_tags_widget_tag_item = new Color(
            id: 'color-blog-tags-widget-tag-item',
            value: '#C51E3A',
            title: esc_html__('Tags Widget Background Hover Color', 'phox'),
            description: 'Set the color of the tags widget background when hovered.'
        );

        $color_blog_comments_title = new Color(
            id: 'color-blog-comments-title',
            value: '#204056',
            title: esc_html__('Comments Area Title Text Color', 'phox'),
            description: 'Set the color of the comments area title text.'
        );

        $color_blog_comment_reply_link = new Color(
            id: 'color-blog-comment-reply-link',
            value: '#204056',
            title: esc_html__('Comments Reply Link Text Color', 'phox'),
            description: 'set the color of the comments reply link text.'
        );

        $color_blog_comment_reply_link_border = new Color(
            id: 'color-blog-comment-reply-link-border',
            value: '#204056',
            title: esc_html__('Comments Reply Link Border', 'phox'),
            description: 'Set the color of the comments reply link border.'
        );

        $color_blog_comment_user = new Color(
            id: 'color-blog-comment-user',
            value: '#204056',
            title: esc_html__('Comments User Text Color', 'phox'),
            description: 'Set the color of the comments user text.'
        );

        $color_blog_reply_title = new Color(
            id: 'color-blog-reply-title',
            value: '#204056',
            title: esc_html__('Add Reply Title Text Color', 'phox'),
            description: 'Set the color of the add reply title text.'
        );

        $color_blog_reply_logged = new Color(
            id: 'color-blog-reply-logged',
            value: '#234961',
            title: esc_html__('Add Reply Logged in user Text Color', 'phox'),
            description: 'Set the color of the add reply logged in user text.'
        );

        $color_blog_comment_input_hvr = new Color(
            id: 'color-blog-comment-input-hvr',
            value: '#204056',
            title: esc_html__('Add Comment Inputs Border Hover', 'phox'),
            description: 'Set the color of the add comment inputs border when hovered.'
        );

        $color_blog_comment_input_send = new Color(
            id: 'color-blog-comment-input-send',
            value: '#204056',
            title: esc_html__('Add Comment Send Button Background', 'phox'),
            description: 'Set the color of the add comment send button.'
        );

        $color_blog_comment_input_send_hvr = new Color(
            id: 'color-blog-comment-input-send-hvr',
            value: '#c51e3a',
            title: esc_html__('Add Comment Send Button Hover Background', 'phox'),
            description: 'Set the color of the add comment send button when hovered.'
        );

        $this->add_section_collection($section_blog,[
            $color_blog_breadcrumb,
            $color_blog_breadcrumb_title,
            $color_blog_breadcrumb_description,
            $color_blog_breadcrumb_link,
            $color_blog_breadcrumb_link_active,
            $color_blog_breadcrumb_link_separator,
            $color_blog_post_title,
            $color_blog_post_title_hover,
            $color_blog_post_more_btn,
            $color_blog_post_more_btn_border,
            $color_blog_post_more_btn_bg_hvr,
            $color_blog_post_more_btn_hvr,
            $color_blog_post_more_btn_border_hvr,
            $color_blog_widget_title,
            $color_blog_widget_link,
            $color_blog_search_widget_send,
            $color_blog_widget_posts_title_clr,
            $color_blog_widget_posts_title_clr_hvr,
            $color_blog_post_heading_main,
            $color_blog_tags_widget_tag,
            $color_blog_related_posts_title,
            $color_blog_related_posts_title_hvr,
            $color_blog_tags_widget_tag_item,
            $color_blog_comments_title,
            $color_blog_comment_reply_link,
            $color_blog_comment_reply_link_border,
            $color_blog_comment_user,
            $color_blog_reply_title,
            $color_blog_reply_logged,
            $color_blog_comment_input_hvr,
            $color_blog_comment_input_send,
            $color_blog_comment_input_send_hvr
        ]);
    }

}