<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Color;
use Phox\core\admin\panel\wdes_options\pages\elements\Media;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;
use Phox\core\admin\panel\wdes_options\pages\elements\TextArea;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;

class Page_404 extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_layout_section();
        $this->create_content_section();
    }

    private function create_layout_section()
    {
        $section_layout = new Sections(
            section_name: esc_html__('Layout', 'phox'),
            description: '',
            doc_link: 'pages-options/#page404'
        );

        $toggle_hide_header = new Toggle(
            id: 'page404-header',
            value: false,
            title: esc_html__('Hide Header','phox'),
            description: 'Turn on to hide the header.'
        );

        $toggle_hide_footer = new Toggle(
            id: 'page404-footer',
            value: false,
            title: esc_html__('Hide Footer','phox'),
            description: 'Turn on to hide the footer.'
        );

        $color_background = new Color(
           id: 'page404-background',
           value: '#ffffff',
           title: esc_html__('Background Color','phox'),
           description: esc_html__('Controls the background color of the page.', 'phox')
        );

        $media_background_image = new Media(
            id: 'page404-background-img',
            value: '',
            title: esc_html__('Background Image','phox'),
            description:esc_html__('Controls the background image of the page.', 'phox')
        );

        $color_main = new Color(
            id: 'page404-main',
            value: '#204056',
            title: esc_html__('Heading Color','phox'),
            description: 'Set the color of the heading.'
        );

        $color_desc = new Color(
            id: 'page404-desc',
            value: '#7e7e7e',
            title: esc_html__('Description Color','phox'),
            description: 'Set the color of the description.'
        );

        $this->add_section_collection($section_layout,[
            $toggle_hide_header,
            $toggle_hide_footer,
            $color_background,
            $media_background_image,
            $color_main,
            $color_desc
        ]);
    }

    private function create_content_section():void
    {
        $section_content = new Sections(
            section_name: esc_html__('Content', 'phox'),
            description: '',
            doc_link: 'pages-options/#page404'
        );

        $text_title = new Text(
            id: 'page404-main-text',
            value: '404',
            title: esc_html__('Heading','phox'),
            description: 'Set the heading of the page.'
        );

        $textarea_desc = new Textarea(
            id: 'page404-desc-text',
            value: 'OOPS! PAGE NOT FOUND',
            title: esc_html__('Description','phox'),
            description: 'Set the description of the page.'
        );

        $this->add_section_collection($section_content,[
            $text_title,
            $textarea_desc
        ]);
    }
}