<?php

namespace Phox\core\admin\panel\wdes_options\pages;

interface Elements_Interface{

    /**
     * Default
     *
     * Get the new data and compare it with the default value for the element
     *
     * @since 2.3.6
     * @return void
     */
    public function default() : void;

    /**
     * Render
     *
     * Prepare element data and send it with all values
     *
     * @since 2.3.6
     * @return array
     */
    public function render() : array;

    /**
     * Type
     *
     * Get the element type;
     *
     * @since 2.3.6
     * @return string
     */
    public function type() : string;

    /**
     * ID
     *
     * Set the id value to the property $id
     *
     * @since 2.3.6
     * @param string $id The id value
     * @return void
     */
    public function id(string $id): void;

    /**
     * Label
     *
     * Set the label value to the property $label
     *
     * @since 2.3.6
     * @param string $label The label value
     * @return void
     */
    public function label(string $label) : void;

    /**
     * Description
     *
     * Set the description value to the property $description
     *
     * @since 2.3.6
     * @param string $description The Description value
     * @return void
     */
    public function description(string $description) : void;

    /**
     * Value
     *
     * Set the default value to the property $value
     *
     * @since 2.3.6
     * @param string $value The default value
     * @return void
     */
    public function value(string $value) : void;

    /**
     * Saved Value
     *
     * Get element value for database if it saved
     *
     * @since 2.3.6
     * @return mixed
     */
    public function saved_value():mixed;

    /**
     * Validate Type
     *
     * Set validation type
     *
     * @return mixed
     */
    public function validate_type();
}