<?php
!defined('ABSPATH') && exit;

use Phox\core\admin\Enqueue;
use Phox\core\admin\Status;
use Phox\core\License_Activation;

//Register Menu
/** @var Phox\core\admin\Dashboard_Menu $dashborad_menu */
/** @var string $icon */
/** @var int|float|null $position */
$theme_option_url = add_query_arg(
    array(
        'page' => 'phox_options',
    ),
    admin_url('admin.php')
);

$builder_url = add_query_arg(
    array(
        'post_type' => 'wdes-theme-builder',
        'wdes_library_type' => 'wdes_header',
    ),
    admin_url('edit.php')
);

$builder_footer_url = add_query_arg(
    array(
        'post_type' => 'wdes-theme-builder',
        'wdes_library_type' => 'wdes_footer',
    ),
    admin_url('edit.php')
);

$builder_popup_url = add_query_arg(
    array(
        'post_type' => 'wdes-popup',
    ),
    admin_url('edit.php')
);

$dashborad_url = add_query_arg(
    array(
        'page' => 'phox',
    ),
    admin_url('admin.php')
);
$import_plugin_url = add_query_arg(
    array(
        'page' => 'wdes-demo-import',
    ),
    admin_url('themes.php')
);
$status_class = new Status();
$license = new License_Activation();

$dashborad_menu->set_render_vars([
    'dashborad_url' => $dashborad_url,
    'theme_option_url' => esc_url($theme_option_url),
    'import_plugin_url' => $import_plugin_url,
    'builder_url' => $builder_url,
    'builder_footer_url' => $builder_footer_url,
    'builder_popup_url' => $builder_popup_url,
    'status' => $status_class->get_status(),
    'data' => $status_class->get_data(),
    'purchase_code' =>$license->show_license_code()
]);


$dashborad_menu->register_main_menu(
    path: WDES_ADMIN_DIR . '/templates-parts/home.php',
    icon: $icon,
    position: $position
);

//Change Menu Name
/** @var Phox\core\admin\Dashboard_Menu $dashborad_menu */
$dashborad_menu->apply_new_menu_name('Dashboard');

$dashboard_enqueue = new Enqueue();
//register Css &Js files
$dashboard_enqueue->set_base_url(WDES_ADMIN_ASSETS_URI);

$dashboard_enqueue->enqueue_media();
$dashboard_enqueue->add_style('admin', 'admin-style', []);
$dashboard_enqueue->add_style('dashboard', 'dashboard-style', []);
$dashboard_enqueue->add_script('dashboard', 'dashboard-script', []);

$dashboard_enqueue->add_inline_script(
    handle: 'jquery',
    data: 'const wdesAdminAjaxLicenseRevoke = ' .json_encode( [
        'nonce'         => wp_create_nonce( 'wdes-license-activation-url-nonce' )
    ]).';',
    position: 'before'
);

$dashboard_enqueue->add_google_font(
    'Inter',
    [
        '400',
        '500',
        '600',
        '700'
    ]
);
$dashboard_enqueue->set_hook_suffix('toplevel_page_phox');
//Fire when admin page load
$dashboard_enqueue->enqueue_admin();
